/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.ecommons.resources.core.ProjectUtils;
import org.eclipse.statet.internal.r.core.Messages;
import org.eclipse.statet.internal.r.core.RProjectNature;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.r.core.RProject;

@NonNullByDefault
public class RProjects {
    public static final String R_NATURE_ID = "org.eclipse.statet.r.resourceProjects.R";
    public static final String R_PKG_NATURE_ID = "org.eclipse.statet.r.resourceProjects.RPkg";

    public static @Nullable RProject getRProject(@Nullable IProject project) {
        return RProjectNature.getRProject(project);
    }

    public static void setupRProject(IProject project, @Nullable IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.RProject_ConfigureTask_label, (Object)project.getName()), (int)10);
        IProjectDescription description = project.getDescription();
        boolean changed = false;
        changed |= ProjectUtils.addNature((IProjectDescription)description, (String)"org.eclipse.statet.ide.resourceProjects.Statet");
        progress.worked(2);
        if (changed |= ProjectUtils.addNature((IProjectDescription)description, (String)R_NATURE_ID)) {
            project.setDescription(description, (IProgressMonitor)progress.newChild(8));
        }
    }

    public static void setupRPkgProject(IProject project, @Nullable IPath pkgBasePath, @Nullable IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.RProject_ConfigureTask_label, (Object)project.getName()), (int)10);
        IProjectDescription description = project.getDescription();
        boolean changed = false;
        changed |= ProjectUtils.addNature((IProjectDescription)description, (String)"org.eclipse.statet.ide.resourceProjects.Statet");
        changed |= ProjectUtils.addNature((IProjectDescription)description, (String)R_NATURE_ID);
        m.worked(2);
        if (changed |= ProjectUtils.addNature((IProjectDescription)description, (String)R_PKG_NATURE_ID)) {
            project.setDescription(description, (IProgressMonitor)m.newChild(8));
        }
        m.setWorkRemaining(2);
        RProjectNature rProject = (RProjectNature)ObjectUtils.nonNullAssert((Object)RProjectNature.getRProject(project));
        PreferenceUtils.setPrefValue((IScopeContext)rProject.getProjectContext(), RProject.PKG_BASE_FOLDER_PATH_PREF, (Object)(pkgBasePath != null ? pkgBasePath.toPortableString() : null), (int)1);
    }
}

