/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.core.util;

import java.util.EnumSet;
import org.eclipse.statet.ecommons.models.AbstractSettingsModelObject;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.nico.core.runtime.SubmitType;

@NonNullByDefault
public class TrackingConfiguration
extends AbstractSettingsModelObject {
    static int DEFAULT_FILE_MODE = 1;
    private final String id;
    private String name;
    private boolean trackStreamInfo;
    private boolean trackStreamInput;
    private boolean trackStreamInputHistoryOnly;
    private boolean trackStreamOutput;
    private boolean trackStreamOutputTruncate;
    private int trackStreamOutputTruncateLines;
    private EnumSet<SubmitType> submitTypes;
    private String fFilePath;
    private int fFileMode;
    private boolean prependTimestamp;

    public TrackingConfiguration(String id) {
        this.id = id;
        this.name = "";
        this.loadDefaults();
    }

    public TrackingConfiguration(String id, TrackingConfiguration template) {
        this.id = id;
        this.name = template.name;
        this.trackStreamInfo = template.trackStreamInfo;
        this.trackStreamInput = template.trackStreamInput;
        this.trackStreamInputHistoryOnly = template.trackStreamInputHistoryOnly;
        this.trackStreamOutput = template.trackStreamOutput;
        this.trackStreamOutputTruncate = template.trackStreamOutputTruncate;
        this.trackStreamOutputTruncateLines = template.trackStreamOutputTruncateLines;
        this.submitTypes = template.submitTypes;
        this.fFilePath = template.fFilePath;
        this.fFileMode = template.fFileMode;
        this.prependTimestamp = template.prependTimestamp;
    }

    public void loadDefaults() {
        this.setTrackStreamInfo(true);
        this.setTrackStreamInput(true);
        this.setTrackStreamInputHistoryOnly(false);
        this.setTrackStreamOutput(true);
        this.setTrackStreamOutputTruncate(false);
        this.setTrackStreamOutputTruncateLines(50);
        this.setSubmitTypes(SubmitType.getDefaultSet());
        this.setFilePath("");
        this.setFileMode(DEFAULT_FILE_MODE);
        this.setPrependTimestamp(true);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String label) {
        String oldValue = this.name;
        this.name = label;
        this.firePropertyChange("name", oldValue, label);
    }

    public boolean getTrackStreamInfo() {
        return this.trackStreamInfo;
    }

    public void setTrackStreamInfo(boolean enable) {
        boolean oldValue = this.trackStreamInfo;
        this.trackStreamInfo = enable;
        this.firePropertyChange("trackStreamInfo", oldValue, enable);
    }

    public boolean getTrackStreamInput() {
        return this.trackStreamInput;
    }

    public void setTrackStreamInput(boolean enable) {
        boolean oldValue = this.trackStreamInput;
        this.trackStreamInput = enable;
        this.firePropertyChange("trackStreamInput", oldValue, enable);
    }

    public boolean getTrackStreamInputHistoryOnly() {
        return this.trackStreamInputHistoryOnly;
    }

    public void setTrackStreamInputHistoryOnly(boolean enable) {
        boolean oldValue = this.trackStreamInputHistoryOnly;
        this.trackStreamInputHistoryOnly = enable;
        this.firePropertyChange("trackStreamInputHistoryOnly", oldValue, enable);
    }

    public boolean getTrackStreamOutput() {
        return this.trackStreamOutput;
    }

    public void setTrackStreamOutput(boolean enable) {
        boolean oldValue = this.trackStreamOutput;
        this.trackStreamOutput = enable;
        this.firePropertyChange("trackStreamOutput", oldValue, enable);
    }

    public boolean getTrackStreamOutputTruncate() {
        return this.trackStreamOutputTruncate;
    }

    public void setTrackStreamOutputTruncate(boolean enable) {
        boolean oldValue = this.trackStreamOutputTruncate;
        this.trackStreamOutputTruncate = enable;
        this.firePropertyChange("trackStreamOutputTruncate", oldValue, enable);
    }

    public int getTrackStreamOutputTruncateLines() {
        return this.trackStreamOutputTruncateLines;
    }

    public void setTrackStreamOutputTruncateLines(int lines) {
        int oldValue = this.trackStreamOutputTruncateLines;
        this.trackStreamOutputTruncateLines = lines;
        this.firePropertyChange("trackStreamOutputTruncateLines", oldValue, lines);
    }

    public EnumSet<SubmitType> getSubmitTypes() {
        return this.submitTypes;
    }

    public void setSubmitTypes(EnumSet<SubmitType> typesToInclude) {
        EnumSet<SubmitType> oldValue = this.submitTypes;
        this.submitTypes = typesToInclude;
        this.firePropertyChange("submitTypes", oldValue, typesToInclude);
    }

    public String getFilePath() {
        return this.fFilePath;
    }

    public void setFilePath(String path) {
        String oldValue = this.fFilePath;
        this.fFilePath = path;
        this.firePropertyChange("filePath", oldValue, path);
    }

    public int getFileMode() {
        return this.fFileMode;
    }

    public void setFileMode(int mode) {
        int oldValue = this.fFileMode;
        this.fFileMode = mode;
        this.firePropertyChange("fileMode", oldValue, mode);
    }

    public String getFileEncoding() {
        return "UTF-8";
    }

    public boolean getPrependTimestamp() {
        return this.prependTimestamp;
    }

    public void setPrependTimestamp(boolean enable) {
        boolean oldValue = this.prependTimestamp;
        this.prependTimestamp = enable;
        this.firePropertyChange("prependTimestamp", oldValue, enable);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof TrackingConfiguration && this.id.equals(((TrackingConfiguration)((Object)obj)).id);
    }
}

