/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.redocs.tex.r.core.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.statet.docmlet.tex.core.TexCoreAccess;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommand;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommandSet;
import org.eclipse.statet.docmlet.tex.core.util.TexCoreAccessWrapper;
import org.eclipse.statet.internal.redocs.tex.r.core.SweaveLtxCommands;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;

public class TexRweaveCoreAccessWrapper
extends TexCoreAccessWrapper {
    private static final ImList<TexCommand> LTX_SWEAVE_COMMAND_LIST = ImCollections.newList((Object[])new TexCommand[]{SweaveLtxCommands.SWEAVE_Sexpr_COMMANDS, SweaveLtxCommands.SWEAVE_SweaveOpts_COMMANDS});
    private static final WeakHashMap<TexCommandSet, TexCommandSet> COMMAND_CACHE = new WeakHashMap();
    private TexCommandSet texCommandSetOrg;
    private volatile TexCommandSet texCommandSet;

    public TexRweaveCoreAccessWrapper(TexCoreAccess texCoreAccess) {
        super(texCoreAccess);
    }

    public TexCommandSet getTexCommandSet() {
        if (this.texCommandSetOrg != super.getTexCommandSet()) {
            this.updateTexCommandSet();
        }
        return this.texCommandSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTexCommandSet() {
        WeakHashMap<TexCommandSet, TexCommandSet> weakHashMap = COMMAND_CACHE;
        synchronized (weakHashMap) {
            TexCommandSet org = super.getTexCommandSet();
            if (this.texCommandSetOrg == org) {
                return;
            }
            TexCommandSet set = COMMAND_CACHE.get(org);
            if (set == null) {
                set = new TexCommandSet(this.addSweaveList(org.getAllLtxCommands()), org.getAllLtxEnvs(), this.addSweaveMap(org.getLtxTextCommandsASorted()), this.addSweaveListASorted(org.getLtxTextCommandsASorted()), org.getLtxTextEnvMap(), org.getLtxTextEnvsASorted(), org.getLtxPreambleCommandMap(), org.getLtxPreambleCommandsASorted(), this.addSweaveMap(org.getLtxMathCommandsASorted()), this.addSweaveListASorted(org.getLtxMathCommandsASorted()), org.getLtxMathEnvMap(), org.getLtxMathEnvsASorted(), org.getLtxInternEnvMap());
                COMMAND_CACHE.put(org, set);
            }
            this.texCommandSet = set;
            this.texCommandSetOrg = org;
        }
    }

    private Map<String, TexCommand> addSweaveMap(List<TexCommand> org) {
        HashMap<String, TexCommand> map = new HashMap<String, TexCommand>(org.size() + 2);
        for (TexCommand command : org) {
            map.put(command.getControlWord(), command);
        }
        for (TexCommand command : LTX_SWEAVE_COMMAND_LIST) {
            map.put(command.getControlWord(), command);
        }
        return Collections.unmodifiableMap(map);
    }

    private List<TexCommand> addSweaveList(List<TexCommand> org) {
        return ImCollections.concatList(org, LTX_SWEAVE_COMMAND_LIST);
    }

    private ImList<TexCommand> addSweaveListASorted(List<TexCommand> org) {
        ImList list = ImCollections.concatList(org, LTX_SWEAVE_COMMAND_LIST, null);
        return list;
    }
}

