/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.model.LtxSourceUnitModelInfo;
import org.eclipse.statet.docmlet.tex.core.model.TexNameAccess;
import org.eclipse.statet.docmlet.tex.core.model.TexSourceUnit;
import org.eclipse.statet.ecommons.runtime.core.util.MessageBuilder;
import org.eclipse.statet.internal.docmlet.tex.core.model.ProblemMessages;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.issues.core.BasicProblem;
import org.eclipse.statet.ltk.issues.core.Problem;
import org.eclipse.statet.ltk.issues.core.ProblemRequestor;
import org.eclipse.statet.ltk.model.core.element.NameAccessSet;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;

@NonNullByDefault
public class LtxProblemModelCheck {
    private static final int REF_LABEL_LIMIT = 50;
    private static final int BUFFER_SIZE = 100;
    private SourceUnit sourceUnit = (SourceUnit)ObjectUtils.nonNullLateInit();
    private SourceContent sourceContent = (SourceContent)ObjectUtils.nonNullLateInit();
    private ProblemRequestor currentRequestor = (ProblemRequestor)ObjectUtils.nonNullLateInit();
    private final MessageBuilder messageBuilder = new MessageBuilder();
    private final List<Problem> problemBuffer = new ArrayList<Problem>(100);
    private final int levelRefUndefined = 1;

    public void run(TexSourceUnit su, SourceContent content, LtxSourceUnitModelInfo model, ProblemRequestor requestor) {
        try {
            this.sourceUnit = (SourceUnit)ObjectUtils.nonNullAssert((Object)su);
            this.sourceContent = (SourceContent)ObjectUtils.nonNullAssert((Object)content);
            this.currentRequestor = (ProblemRequestor)ObjectUtils.nonNullAssert((Object)requestor);
            this.checkLabels(model);
            if (this.problemBuffer.size() > 0) {
                this.currentRequestor.acceptProblems("Ltx", this.problemBuffer);
            }
        }
        finally {
            this.problemBuffer.clear();
            this.sourceUnit = null;
            this.currentRequestor = null;
        }
    }

    private void checkLabels(LtxSourceUnitModelInfo model) {
        NameAccessSet<TexNameAccess> labelSet = model.getLabels();
        ImList labels = labelSet.getNames();
        block0: for (String label : labels) {
            if (label == null || label.length() <= 0) continue;
            ImList accessList = (ImList)ObjectUtils.nonNullAssert((Object)labelSet.getAllInUnit(label));
            for (TexNameAccess access : accessList) {
                if (access.isWriteAccess()) continue block0;
            }
            for (TexNameAccess access : accessList) {
                TexAstNode nameNode = (TexAstNode)access.getNameNode();
                this.addProblem(1, 8497, this.messageBuilder.bind(ProblemMessages.Labels_UndefinedRef_message, (Object)access.getDisplayName()), nameNode.getStartOffset(), nameNode.getEndOffset());
            }
        }
    }

    protected final void addProblem(int severity, int code, String message, int startOffset, int endOffset) {
        if (startOffset < this.sourceContent.getStartOffset()) {
            startOffset = this.sourceContent.getStartOffset();
        }
        if (endOffset > this.sourceContent.getEndOffset()) {
            endOffset = this.sourceContent.getEndOffset();
        }
        this.problemBuffer.add((Problem)new BasicProblem("Ltx", severity, code, message, startOffset, endOffset));
        if (this.problemBuffer.size() >= 100) {
            this.currentRequestor.acceptProblems("Ltx", this.problemBuffer);
            this.problemBuffer.clear();
        }
    }
}

