/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.preferences.core;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.NullDefaultLocation;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault(value={NullDefaultLocation.PARAMETER, NullDefaultLocation.RETURN_TYPE, NullDefaultLocation.FIELD, NullDefaultLocation.ARRAY_CONTENTS})
public abstract class Preference<T> {
    private static final Collator DEFAULT_COLLATOR = Collator.getInstance((Locale)Locale.ENGLISH);
    private final String qualifier;
    private final String key;
    public static final char LIST_SEPARATOR_CHAR = ',';
    protected static final Pattern LIST_SEPARATOR_PATTERN;
    public static final char IS2_SEPARATOR_CHAR = '\u001e';
    protected static final Pattern IS2_SEPARATOR_PATTERN;
    public static final char IS1_SEPARATOR_CHAR = '\u001f';
    protected static final Pattern IS1_SEPARATOR_PATTERN;

    static {
        ((RuleBasedCollator)DEFAULT_COLLATOR).setUpperCaseFirst(true);
        LIST_SEPARATOR_PATTERN = Pattern.compile(",");
        IS2_SEPARATOR_PATTERN = Pattern.compile("\u001e");
        IS1_SEPARATOR_PATTERN = Pattern.compile("\u001f");
    }

    protected Preference(String qualifier, String key) {
        this.qualifier = qualifier;
        this.key = key;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getKey() {
        return this.key;
    }

    public abstract Class<T> getUsageType();

    public abstract @Nullable String usage2Store(T var1);

    public abstract T store2Usage(@Nullable String var1);

    public String toString() {
        return String.valueOf(this.qualifier) + '/' + this.key;
    }

    public int hashCode() {
        return this.qualifier.hashCode() + this.key.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            Preference other = (Preference)obj;
            return this.qualifier.equals(other.getQualifier()) && this.key.equals(other.getQualifier());
        }
        return false;
    }

    @NonNullByDefault
    public static final class BooleanPref
    extends Preference<Boolean> {
        private final Boolean defaultValue;

        public BooleanPref(String qualifier, String key, boolean defaultValue) {
            super(qualifier, key);
            this.defaultValue = defaultValue;
        }

        public BooleanPref(String qualifier, String key) {
            this(qualifier, key, false);
        }

        @Override
        public Class<Boolean> getUsageType() {
            return Boolean.class;
        }

        @Override
        public Boolean store2Usage(@Nullable String storeValue) {
            if (storeValue != null) {
                return Boolean.valueOf(storeValue);
            }
            return this.defaultValue;
        }

        @Override
        public String usage2Store(Boolean usageValue) {
            return usageValue.toString();
        }
    }

    @NonNullByDefault
    public static final class DoublePref
    extends Preference<Double> {
        private final double defaultValue;

        public DoublePref(String qualifier, String key, double defaultValue) {
            super(qualifier, key);
            this.defaultValue = defaultValue;
        }

        public DoublePref(String qualifier, String key) {
            this(qualifier, key, 0.0);
        }

        @Override
        public Class<Double> getUsageType() {
            return Double.class;
        }

        @Override
        public Double store2Usage(@Nullable String storeValue) {
            if (storeValue != null) {
                try {
                    return Double.valueOf(storeValue);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return this.defaultValue;
        }

        @Override
        public String usage2Store(Double usageValue) {
            return usageValue.toString();
        }
    }

    @NonNullByDefault
    public static class EnumListPref<E extends Enum<E>>
    extends Preference<List<E>> {
        private final Class<E> enumType;

        public EnumListPref(String qualifier, String key, Class<E> enumType) {
            super(qualifier, key);
            this.enumType = enumType;
        }

        @Override
        public Class getUsageType() {
            return List.class;
        }

        @Override
        public List<E> store2Usage(@Nullable String storeValue) {
            if (storeValue != null && !storeValue.isEmpty()) {
                String[] values = LIST_SEPARATOR_PATTERN.split(storeValue);
                ArrayList<@NonNull E> list = new ArrayList<E>(values.length);
                String[] stringArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    if (name.length() > 0) {
                        try {
                            list.add(Enum.valueOf(this.enumType, name));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
                return list;
            }
            return ImCollections.emptyList();
        }

        @Override
        public String usage2Store(List<E> usageValue) {
            if (usageValue.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (Enum e : usageValue) {
                sb.append(e.name());
                sb.append(',');
            }
            return sb.substring(0, sb.length() - 1);
        }
    }

    @NonNullByDefault
    public static class EnumPref<E extends Enum<E>>
    extends Preference<E> {
        private final Class<E> enumType;
        private final E defaultValue;

        public EnumPref(String qualifier, String key, Class<E> enumType, E defaultValue) {
            super(qualifier, key);
            this.enumType = enumType;
            this.defaultValue = defaultValue;
        }

        @Override
        public Class<E> getUsageType() {
            return this.enumType;
        }

        @Override
        public E store2Usage(@Nullable String storeValue) {
            if (storeValue != null) {
                try {
                    return Enum.valueOf(this.enumType, storeValue);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return this.defaultValue;
        }

        @Override
        public @Nullable String usage2Store(E usageValue) {
            return ((Enum)usageValue).name();
        }
    }

    @NonNullByDefault
    public static class EnumSetPref<E extends Enum<E>>
    extends Preference<EnumSet<E>> {
        private final Class<E> enumType;

        public EnumSetPref(String qualifier, String key, Class<E> enumType) {
            super(qualifier, key);
            this.enumType = enumType;
        }

        @Override
        public Class getUsageType() {
            return EnumSet.class;
        }

        @Override
        public EnumSet<E> store2Usage(@Nullable String storeValue) {
            EnumSet<E> set = EnumSet.noneOf(this.enumType);
            if (storeValue != null && !storeValue.isEmpty()) {
                String[] values;
                String[] stringArray = values = LIST_SEPARATOR_PATTERN.split(storeValue);
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    if (name.length() > 0) {
                        set.add(Enum.valueOf(this.enumType, name));
                    }
                    ++n2;
                }
            }
            return set;
        }

        @Override
        public String usage2Store(EnumSet<E> usageValue) {
            if (usageValue.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (Enum e : usageValue) {
                sb.append(e.name());
                sb.append(',');
            }
            return sb.substring(0, sb.length() - 1);
        }
    }

    @NonNullByDefault
    public static final class FloatPref
    extends Preference<Float> {
        private final Float defaultValue;

        public FloatPref(String qualifier, String key, float defaultValue) {
            super(qualifier, key);
            this.defaultValue = Float.valueOf(defaultValue);
        }

        public FloatPref(String qualifier, String key) {
            this(qualifier, key, 0.0f);
        }

        @Override
        public Class<Float> getUsageType() {
            return Float.class;
        }

        @Override
        public Float store2Usage(@Nullable String storeValue) {
            if (storeValue != null) {
                try {
                    return Float.valueOf(storeValue);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return this.defaultValue;
        }

        @Override
        public String usage2Store(Float usageValue) {
            return usageValue.toString();
        }
    }

    @NonNullByDefault
    public static final class IntPref
    extends Preference<Integer> {
        private final Integer defaultValue;

        public IntPref(String qualifier, String key, int defaultValue) {
            super(qualifier, key);
            this.defaultValue = defaultValue;
        }

        public IntPref(String qualifier, String key) {
            this(qualifier, key, 0);
        }

        @Override
        public Class<Integer> getUsageType() {
            return Integer.class;
        }

        @Override
        public Integer store2Usage(@Nullable String storeValue) {
            if (storeValue != null) {
                try {
                    return Integer.valueOf(storeValue);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return this.defaultValue;
        }

        @Override
        public String usage2Store(Integer usageValue) {
            return usageValue.toString();
        }
    }

    @NonNullByDefault
    public static final class LongPref
    extends Preference<Long> {
        private final Long defaultValue;

        public LongPref(String qualifier, String key, long defaultValue) {
            super(qualifier, key);
            this.defaultValue = defaultValue;
        }

        public LongPref(String qualifier, String key) {
            this(qualifier, key, 0L);
        }

        @Override
        public Class<Long> getUsageType() {
            return Long.class;
        }

        @Override
        public Long store2Usage(@Nullable String storeValue) {
            if (storeValue != null) {
                try {
                    return Long.valueOf(storeValue);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return this.defaultValue;
        }

        @Override
        public String usage2Store(Long usageValue) {
            return usageValue.toString();
        }
    }

    public static final class NullableStringPref
    extends Preference<String> {
        public NullableStringPref(String qualifier, String key) {
            super(qualifier, key);
        }

        @Override
        public Class<String> getUsageType() {
            return String.class;
        }

        @Override
        public @Nullable String store2Usage(@Nullable String storeValue) {
            return storeValue;
        }

        @Override
        public @Nullable String usage2Store(@Nullable String usageValue) {
            return usageValue;
        }
    }

    public static class StringArrayPref
    extends Preference<String[]> {
        private static final String[] EMPTY_ARRAY = new String[0];
        private final char separator;

        public StringArrayPref(String qualifier, String key) {
            super(qualifier, key);
            this.separator = (char)44;
        }

        public StringArrayPref(String qualifier, String key, char separator) {
            super(qualifier, key);
            this.separator = separator;
        }

        @Override
        public Class<String[]> getUsageType() {
            return String[].class;
        }

        @Override
        public String[] store2Usage(@Nullable String storeValue) {
            if (storeValue != null && !storeValue.isEmpty()) {
                switch (this.separator) {
                    case ',': {
                        return LIST_SEPARATOR_PATTERN.split(storeValue);
                    }
                    case '\u001e': {
                        return IS2_SEPARATOR_PATTERN.split(storeValue);
                    }
                }
                return (this.separator == ',' ? LIST_SEPARATOR_PATTERN : Pattern.compile("\\Q" + this.separator + "\\E")).split(storeValue);
            }
            return EMPTY_ARRAY;
        }

        @Override
        public String usage2Store(String[] usageValue) {
            if (usageValue.length == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < usageValue.length) {
                sb.append(usageValue[i]);
                sb.append(this.separator);
                ++i;
            }
            return sb.substring(0, sb.length() - 1);
        }
    }

    @NonNullByDefault
    public static final class StringPref
    extends Preference<String> {
        private final String defaultValue;

        public StringPref(String qualifier, String key, String defaultValue) {
            super(qualifier, key);
            this.defaultValue = defaultValue;
        }

        public StringPref(String qualifier, String key) {
            this(qualifier, key, "");
        }

        @Override
        public Class<String> getUsageType() {
            return String.class;
        }

        @Override
        public String store2Usage(@Nullable String storeValue) {
            if (storeValue != null) {
                return storeValue;
            }
            return this.defaultValue;
        }

        @Override
        public String usage2Store(String usageValue) {
            return usageValue;
        }
    }

    public static class StringSetPref
    extends Preference<Set<String>> {
        public StringSetPref(String qualifier, String key) {
            super(qualifier, key);
        }

        @Override
        public Class<Set<String>> getUsageType() {
            Class<Set> o = Set.class;
            return o;
        }

        @Override
        public Set<@NonNull String> store2Usage(@Nullable String storeValue) {
            if (storeValue != null && !storeValue.isEmpty()) {
                Object[] strings = LIST_SEPARATOR_PATTERN.split(storeValue);
                return strings.length <= 16 ? ImCollections.newSet((Object[])strings) : new HashSet(ImCollections.newList((Object[])strings));
            }
            return ImCollections.emptySet();
        }

        @Override
        public String usage2Store(Set<@NonNull String> usageValue) {
            if (usageValue.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            String[] array = usageValue.toArray(new String[usageValue.size()]);
            Arrays.sort(array, DEFAULT_COLLATOR);
            int i = 0;
            while (i < array.length) {
                sb.append(array[i]);
                sb.append(',');
                ++i;
            }
            return sb.substring(0, sb.length() - 1);
        }
    }
}

