/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.editors.templates;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.ecommons.text.IndentUtil;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.templates.SourceEditorTemplateContext;
import org.eclipse.statet.r.core.RCodeStyleSettings;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.rlang.RTokens;
import org.eclipse.statet.r.core.rsource.RLexer;
import org.eclipse.statet.r.core.rsource.RTerminal;
import org.eclipse.statet.r.ui.editors.RSourceEditor;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

@NonNullByDefault
public class REditorContext
extends SourceEditorTemplateContext {
    public REditorContext(TemplateContextType type, IDocument document, TextRegion region, SourceEditor editor, int flags) {
        super(type, document, region, editor, flags);
    }

    protected RCoreAccess getRCoreAccess() {
        SourceEditor editor = this.getEditor();
        return editor instanceof RSourceEditor ? ((RSourceEditor)editor).getRCoreAccess() : RCore.WORKBENCH_ACCESS;
    }

    public void setVariable(String name, @Nullable String value) {
        if ("selection".equals(name) && value != null && value.length() > 0) {
            try {
                Document valueDoc = new Document(value);
                final IndentUtil util = new IndentUtil((IDocument)valueDoc, (IIndentSettings)this.getRCoreAccess().getRCodeStyle());
                final int column = util.getMultilineIndentColumn(0, valueDoc.getNumberOfLines() - 1);
                if (column > 0) {
                    IndentUtil.IndentEditAction action = new IndentUtil.IndentEditAction(column, (IDocument)valueDoc){
                        private final /* synthetic */ IDocument val$valueDoc;
                        {
                            this.val$valueDoc = iDocument;
                            super($anonymous0);
                        }

                        public void doEdit(int line, int offset, int length, StringBuilder text) throws BadLocationException {
                            DeleteEdit edit;
                            if (text != null) {
                                int position = util.getIndentedOffsetAt((CharSequence)text, column);
                                edit = new ReplaceEdit(offset, length, text.substring(position, text.length()));
                            } else {
                                int end = util.getIndentedOffsetAt(line, column);
                                edit = new DeleteEdit(offset, end - offset);
                            }
                            edit.apply(this.val$valueDoc, 0);
                        }
                    };
                    util.editInIndent(0, valueDoc.getNumberOfLines() - 1, action);
                    this.setVariable("indentation", util.createIndentString(column));
                    value = valueDoc.get();
                }
            }
            catch (BadLocationException e) {
                RUIPlugin.logError(100, "An error occurred while computing indentation variable for R editor templates.", e);
            }
        }
        super.setVariable(name, value);
    }

    protected void format(MultiTextEdit root, IDocument templateDoc, TemplateVariable[] variables, IDocument baseDoc) throws BadLocationException {
        this.indent(root, templateDoc, variables, baseDoc);
        if ((this.getFlags() & 0x20) != 0 && this.getVariable("indentation") == null && this.getStart() > 0 && !RTokens.isWhitespace((int)baseDoc.getChar(this.getStart() - 1)) && templateDoc.getLength() > 0 && !RTokens.isWhitespace((int)templateDoc.getChar(0))) {
            String line = templateDoc.get(0, templateDoc.getLineLength(0));
            RLexer lexer = new RLexer();
            lexer.reset((TextParserInput)new StringParserInput(line).init());
            RCodeStyleSettings rCodeStyle = this.getRCoreAccess().getRCodeStyle();
            RTerminal token = lexer.next();
            if (this.getSpaceBefore(token, rCodeStyle)) {
                root.addChild((TextEdit)new InsertEdit(0, " "));
            }
            if (variables.length == 0 && line.length() == templateDoc.getLength() && lexer.next() == RTerminal.EOF && this.getSpaceAfter(token, rCodeStyle)) {
                root.addChild((TextEdit)new InsertEdit(line.length(), " "));
            }
        }
    }

    protected boolean getSpaceBefore(RTerminal terminal, RCodeStyleSettings rCodeStyle) {
        switch (terminal) {
            case EQUAL: {
                return rCodeStyle.getWhitespaceArgAssignBefore();
            }
            case ARROW_LEFT_S: 
            case ARROW_LEFT_D: {
                return rCodeStyle.getWhitespaceAssignBefore();
            }
            case ARROW_RIGHT_S: 
            case ARROW_RIGHT_D: {
                return rCodeStyle.getWhitespaceArgAssignAfter();
            }
            case PIPE_RIGHT: {
                return rCodeStyle.getWhitespacePipeBefore();
            }
            case PLUS: 
            case MINUS: 
            case MULT: 
            case DIV: 
            case OR: 
            case OR_D: 
            case AND: 
            case AND_D: 
            case NOT: 
            case POWER: 
            case SEQ: 
            case SPECIAL: 
            case COLON_EQUAL: 
            case TILDE: 
            case REL_NE: 
            case REL_EQ: 
            case REL_LT: 
            case REL_LE: 
            case REL_GT: 
            case REL_GE: {
                return rCodeStyle.getWhitespaceOtherOpBefore();
            }
        }
        return true;
    }

    protected boolean getSpaceAfter(RTerminal terminal, RCodeStyleSettings rCodeStyle) {
        switch (terminal) {
            case EQUAL: {
                return rCodeStyle.getWhitespaceArgAssignAfter();
            }
            case ARROW_LEFT_S: 
            case ARROW_LEFT_D: {
                return rCodeStyle.getWhitespaceAssignAfter();
            }
            case ARROW_RIGHT_S: 
            case ARROW_RIGHT_D: {
                return rCodeStyle.getWhitespaceArgAssignBefore();
            }
            case PIPE_RIGHT: {
                return rCodeStyle.getWhitespacePipeAfter();
            }
            case PLUS: 
            case MINUS: 
            case MULT: 
            case DIV: 
            case OR: 
            case OR_D: 
            case AND: 
            case AND_D: 
            case NOT: 
            case POWER: 
            case SEQ: 
            case SPECIAL: 
            case COLON_EQUAL: 
            case TILDE: 
            case REL_NE: 
            case REL_EQ: 
            case REL_LT: 
            case REL_LE: 
            case REL_GT: 
            case REL_GE: {
                return rCodeStyle.getWhitespaceOtherOpAfter();
            }
        }
        return true;
    }
}

