/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.selection;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.LPoint;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.painter.layer.GridLineCellLayerPainter;
import org.eclipse.statet.ecommons.waltable.style.BorderStyle;
import org.eclipse.statet.ecommons.waltable.style.CellStyleAttributes;
import org.eclipse.statet.ecommons.waltable.style.DisplayMode;
import org.eclipse.statet.ecommons.waltable.style.IStyle;
import org.eclipse.statet.ecommons.waltable.swt.SWTUtil;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class SelectionLayerPainter
extends GridLineCellLayerPainter {
    private long columnPositionOffset;
    private long rowPositionOffset;
    private Map<LPoint, ILayerCell> cells;

    @Override
    public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle pixelRectangle, IConfigRegistry configRegistry) {
        LRectangle currentCellBounds;
        ILayerCell currentCell;
        ILayerCell previousCell;
        LRectangle positionRectangle = this.getPositionRectangleFromPixelRectangle(natLayer, pixelRectangle);
        this.columnPositionOffset = positionRectangle.x;
        this.rowPositionOffset = positionRectangle.y;
        this.cells = new HashMap<LPoint, ILayerCell>();
        super.paintLayer(natLayer, gc, xOffset, yOffset, pixelRectangle, configRegistry);
        int originalLineStyle = gc.getLineStyle();
        Color originalForeground = gc.getForeground();
        gc.setLineStyle(6);
        gc.setLineDash(new int[]{1, 1});
        gc.setForeground(GUIHelper.COLOR_BLACK);
        boolean selectedMode = false;
        long columnPosition = this.columnPositionOffset;
        while (columnPosition < this.columnPositionOffset + positionRectangle.width) {
            previousCell = null;
            currentCell = null;
            long rowPosition = this.rowPositionOffset;
            while (rowPosition < this.rowPositionOffset + positionRectangle.height) {
                currentCell = this.cells.get(new LPoint(columnPosition, rowPosition));
                if (currentCell != null && selectedMode != this.isSelected(currentCell)) {
                    selectedMode = !selectedMode;
                    currentCellBounds = currentCell.getBounds();
                    long x0 = GraphicsUtils.safe(currentCellBounds.x - 1L);
                    long x1 = GraphicsUtils.safe(currentCellBounds.x + currentCellBounds.width - 1L);
                    if (previousCell != null) {
                        LRectangle previousCellBounds = previousCell.getBounds();
                        x0 = Math.max(x0, previousCellBounds.x - 1L);
                        x1 = Math.min(x1, previousCellBounds.x + previousCellBounds.width - 1L);
                    }
                    int y = GraphicsUtils.safe(currentCellBounds.y - 1L);
                    gc.drawLine(GraphicsUtils.safe(x0), y, GraphicsUtils.safe(x1), y);
                }
                previousCell = currentCell;
                ++rowPosition;
            }
            if (selectedMode && previousCell != null) {
                LRectangle cellBounds = previousCell.getBounds();
                gc.drawLine(GraphicsUtils.safe(cellBounds.x - 1L), GraphicsUtils.safe(cellBounds.y + cellBounds.height - 1L), GraphicsUtils.safe(cellBounds.x + cellBounds.width - 1L), GraphicsUtils.safe(cellBounds.y + cellBounds.height - 1L));
            }
            selectedMode = false;
            ++columnPosition;
        }
        long rowPosition = this.rowPositionOffset;
        while (rowPosition < this.rowPositionOffset + positionRectangle.height) {
            previousCell = null;
            currentCell = null;
            long columnPosition2 = this.columnPositionOffset;
            while (columnPosition2 < this.columnPositionOffset + positionRectangle.width) {
                currentCell = this.cells.get(new LPoint(columnPosition2, rowPosition));
                if (currentCell != null && selectedMode != this.isSelected(currentCell)) {
                    selectedMode = !selectedMode;
                    currentCellBounds = currentCell.getBounds();
                    int x = GraphicsUtils.safe(currentCellBounds.x - 1L);
                    long y0 = currentCellBounds.y - 1L;
                    long y1 = currentCellBounds.y + currentCellBounds.height - 1L;
                    if (previousCell != null) {
                        LRectangle previousCellBounds = previousCell.getBounds();
                        y0 = Math.max(y0, previousCellBounds.y - 1L);
                        y1 = Math.min(y1, previousCellBounds.y + previousCellBounds.height - 1L);
                    }
                    gc.drawLine(x, GraphicsUtils.safe(y0), x, GraphicsUtils.safe(y1));
                }
                previousCell = currentCell;
                ++columnPosition2;
            }
            if (selectedMode && previousCell != null) {
                LRectangle cellBounds = previousCell.getBounds();
                gc.drawLine(GraphicsUtils.safe(cellBounds.x + cellBounds.width - 1L), GraphicsUtils.safe(cellBounds.y - 1L), GraphicsUtils.safe(cellBounds.x + cellBounds.width - 1L), GraphicsUtils.safe(cellBounds.y + cellBounds.height - 1L));
            }
            selectedMode = false;
            ++rowPosition;
        }
        gc.setLineStyle(originalLineStyle);
        gc.setForeground(originalForeground);
    }

    @Override
    protected void paintCell(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        long columnPosition = cell.getOriginColumnPosition();
        while (columnPosition < cell.getOriginColumnPosition() + cell.getColumnSpan()) {
            long rowPosition = cell.getOriginRowPosition();
            while (rowPosition < cell.getOriginRowPosition() + cell.getRowSpan()) {
                this.cells.put(new LPoint(columnPosition, rowPosition), cell);
                ++rowPosition;
            }
            ++columnPosition;
        }
        super.paintCell(cell, gc, configRegistry);
    }

    private boolean isSelected(ILayerCell cell) {
        return cell.getDisplayMode() == DisplayMode.SELECT;
    }

    private void applyBorderStyle(GC gc, IConfigRegistry configRegistry) {
        BorderStyle borderStyle;
        IStyle cellStyle = configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.SELECT, "selectionAnchorGridLine");
        BorderStyle borderStyle2 = borderStyle = cellStyle != null ? cellStyle.getAttributeValue(CellStyleAttributes.BORDER_STYLE) : null;
        if (borderStyle == null) {
            gc.setLineStyle(6);
            gc.setLineDash(new int[]{1, 1});
            gc.setForeground(GUIHelper.COLOR_BLACK);
        } else {
            gc.setLineStyle(SWTUtil.toSWT(borderStyle.getLineStyle()));
            gc.setLineWidth(borderStyle.getThickness());
            gc.setForeground(borderStyle.getColor());
        }
    }
}

