/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.layer.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.statet.ecommons.waltable.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.event.ColumnVisualChangeEvent;
import org.eclipse.statet.ecommons.waltable.layer.event.IStructuralChangeEvent;
import org.eclipse.statet.ecommons.waltable.layer.event.StructuralDiff;

public abstract class ColumnStructuralChangeEvent
extends ColumnVisualChangeEvent
implements IStructuralChangeEvent {
    public ColumnStructuralChangeEvent(ILayer layer, LRange ... columnPositionRanges) {
        this(layer, Arrays.asList(columnPositionRanges));
    }

    public ColumnStructuralChangeEvent(ILayer layer, Collection<LRange> columnPositionRanges) {
        super(layer, columnPositionRanges);
    }

    protected ColumnStructuralChangeEvent(ColumnStructuralChangeEvent event) {
        super(event);
    }

    @Override
    public Collection<LRectangle> getChangedPositionRectangles() {
        ArrayList<LRectangle> changedPositionRectangles = new ArrayList<LRectangle>();
        Collection<LRange> columnPositionRanges = this.getColumnPositionRanges();
        if (columnPositionRanges != null && columnPositionRanges.size() > 0) {
            long leftmostColumnPosition = Long.MAX_VALUE;
            for (LRange lRange : columnPositionRanges) {
                if (lRange.start >= leftmostColumnPosition) continue;
                leftmostColumnPosition = lRange.start;
            }
            long columnCount = this.getLayer().getColumnCount();
            long rowCount = this.getLayer().getRowCount();
            changedPositionRectangles.add(new LRectangle(leftmostColumnPosition, 0L, columnCount - leftmostColumnPosition, rowCount));
        }
        return changedPositionRectangles;
    }

    @Override
    public boolean isHorizontalStructureChanged() {
        return true;
    }

    @Override
    public boolean isVerticalStructureChanged() {
        return false;
    }

    @Override
    public Collection<StructuralDiff> getRowDiffs() {
        return null;
    }
}

