/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImIdentitySet;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class CollectionUtils {
    public static String toString(List<@NonNull ?> list, String sep) {
        int n = list.size();
        if (n <= 0) {
            return "";
        }
        if (n == 1) {
            return list.get(0).toString();
        }
        if (list instanceof RandomAccess) {
            StringBuilder sb = new StringBuilder(list.get(0).toString());
            int i = 1;
            while (i < n) {
                sb.append(sep);
                sb.append(list.get(i).toString());
                ++i;
            }
            return sb.toString();
        }
        Iterator<?> iter = list.iterator();
        StringBuilder sb = new StringBuilder(iter.next().toString());
        int i = 1;
        while (i < n) {
            sb.append(sep);
            sb.append(iter.next().toString());
            ++i;
        }
        return sb.toString();
    }

    public static String toString(Collection<@NonNull ?> c, String sep) {
        if (c instanceof List) {
            return CollectionUtils.toString((List)c, sep);
        }
        int n = c.size();
        if (n <= 0) {
            return "";
        }
        if (n == 1) {
            return c.iterator().next().toString();
        }
        Iterator<?> iter = c.iterator();
        StringBuilder sb = new StringBuilder(iter.next().toString());
        int i = 1;
        while (i < n) {
            sb.append(sep);
            sb.append(iter.next().toString());
            ++i;
        }
        return sb.toString();
    }

    public static ImIdentityList<String> toIdentifierList(String[] array) {
        int count = 0;
        int i = 0;
        while (i < array.length) {
            String s = array[i];
            if (s != null && !s.isEmpty()) {
                array[count++] = s.intern();
            }
            ++i;
        }
        return ImCollections.newIdentityList(array, 0, count);
    }

    public static ImIdentitySet<String> toIdentifierSet(String[] array) {
        int count = 0;
        int i = 0;
        while (i < array.length) {
            String s = array[i];
            if (s != null && !s.isEmpty()) {
                array[count++] = s.intern();
            }
            ++i;
        }
        return ImCollections.newIdentitySet(array, 0, count);
    }
}

