/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.IOException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.impl.AbstractLogicalStore;
import org.eclipse.statet.rj.data.impl.ExternalizableRStore;
import org.eclipse.statet.rj.data.impl.RDataResizeExtension;

@NonNullByDefault
public class RLogicalInt32Store
extends AbstractLogicalStore
implements RDataResizeExtension<Boolean>,
ExternalizableRStore {
    private int length;
    protected int[] boolValues;

    public RLogicalInt32Store() {
        this.length = 0;
        this.boolValues = EMPTY_INT_ARRAY;
    }

    public RLogicalInt32Store(boolean[] values, int @Nullable [] naIdxs) {
        this.length = values.length;
        this.boolValues = new int[this.length];
        int i = values.length - 1;
        while (i >= 0) {
            this.boolValues[i] = values[i] ? 1 : 0;
            --i;
        }
        if (naIdxs != null) {
            i = 0;
            while (i < naIdxs.length) {
                this.boolValues[naIdxs[i]] = Integer.MIN_VALUE;
                ++i;
            }
        }
    }

    public RLogicalInt32Store(boolean[] values, boolean @Nullable [] isNAs) {
        this.length = values.length;
        this.boolValues = new int[this.length];
        int i = values.length - 1;
        while (i >= 0) {
            this.boolValues[i] = values[i] ? 1 : 0;
            --i;
        }
        if (isNAs != null) {
            if (isNAs.length != this.length) {
                throw new IllegalArgumentException();
            }
            i = 0;
            while (i < isNAs.length) {
                if (isNAs[i]) {
                    this.boolValues[i] = Integer.MIN_VALUE;
                }
                ++i;
            }
        }
    }

    public RLogicalInt32Store(int[] values) {
        this.length = values.length;
        this.boolValues = values;
    }

    public RLogicalInt32Store(RJIO io, int length) throws IOException {
        this.length = length;
        this.boolValues = new int[length];
        int i = 0;
        while (i < this.length) {
            byte b = io.readByte();
            this.boolValues[i] = b == 1 ? 1 : (b == 2 ? Integer.MIN_VALUE : 0);
            ++i;
        }
    }

    @Override
    public void writeExternal(RJIO io) throws IOException {
        int i = 0;
        while (i < this.length) {
            switch (this.boolValues[i]) {
                case 0: {
                    io.writeByte((byte)0);
                    break;
                }
                case -2147483648: {
                    io.writeByte((byte)2);
                    break;
                }
                default: {
                    io.writeByte((byte)1);
                }
            }
            ++i;
        }
    }

    @Override
    protected final boolean isStructOnly() {
        return false;
    }

    protected final int length() {
        return this.length;
    }

    @Override
    public final long getLength() {
        return this.length;
    }

    @Override
    public boolean isNA(int idx) {
        return this.boolValues[idx] == Integer.MIN_VALUE;
    }

    @Override
    public boolean isNA(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.boolValues[(int)idx] == Integer.MIN_VALUE;
    }

    @Override
    public boolean isMissing(int idx) {
        return this.boolValues[idx] == Integer.MIN_VALUE;
    }

    @Override
    public boolean isMissing(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.boolValues[(int)idx] == Integer.MIN_VALUE;
    }

    @Override
    public void setNA(int idx) {
        this.boolValues[idx] = Integer.MIN_VALUE;
    }

    @Override
    public void setNA(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        this.boolValues[(int)idx] = Integer.MIN_VALUE;
    }

    @Override
    public boolean getLogi(int idx) {
        return this.boolValues[idx] != 0;
    }

    @Override
    public boolean getLogi(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.boolValues[(int)idx] != 0;
    }

    @Override
    public void setLogi(int idx, boolean value) {
        this.boolValues[idx] = value ? 1 : 0;
    }

    @Override
    public void setLogi(long idx, boolean value) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        this.boolValues[(int)idx] = value ? 1 : 0;
    }

    private void prepareInsert(int[] idxs) {
        this.boolValues = RLogicalInt32Store.prepareInsert(this.boolValues, this.length, idxs);
        this.length += idxs.length;
    }

    public void insertLogi(int idx, boolean value) {
        this.prepareInsert(new int[]{idx});
        this.boolValues[idx] = value ? 1 : 0;
    }

    @Override
    public void insertNA(int idx) {
        this.prepareInsert(new int[]{idx});
        this.boolValues[idx] = Integer.MIN_VALUE;
    }

    @Override
    public void insertNA(int[] idxs) {
        if (idxs.length == 0) {
            return;
        }
        this.prepareInsert(idxs);
        int idx = 0;
        while (idx < idxs.length) {
            this.boolValues[idxs[idx] + idx] = Integer.MIN_VALUE;
            ++idx;
        }
    }

    @Override
    public void remove(int idx) {
        this.boolValues = RLogicalInt32Store.remove(this.boolValues, this.length, new int[]{idx});
        --this.length;
    }

    @Override
    public void remove(int[] idxs) {
        this.boolValues = RLogicalInt32Store.remove(this.boolValues, this.length, idxs);
        this.length -= idxs.length;
    }

    @Override
    public @Nullable Boolean get(int idx) {
        if (idx < 0 || idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.boolValues[idx] != Integer.MIN_VALUE ? (this.boolValues[idx] == 1 ? Boolean.TRUE : Boolean.FALSE) : null;
    }

    @Override
    public @Nullable Boolean get(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.boolValues[(int)idx] != Integer.MIN_VALUE ? (this.boolValues[(int)idx] == 1 ? Boolean.TRUE : Boolean.FALSE) : null;
    }

    @Override
    public @Nullable Boolean[] toArray() {
        Boolean[] array = new Boolean[this.length];
        int i = 0;
        while (i < array.length) {
            if (this.boolValues[i] != Integer.MIN_VALUE) {
                array[i] = this.boolValues[i] == 1 ? Boolean.TRUE : Boolean.FALSE;
            }
            ++i;
        }
        return array;
    }

    @Override
    public long indexOfNA(long fromIdx) {
        if (fromIdx >= Integer.MAX_VALUE) {
            return -1L;
        }
        if (fromIdx < 0L) {
            fromIdx = 0L;
        }
        long l = this.getLength();
        int[] ints = this.boolValues;
        int i = (int)fromIdx;
        while ((long)i < l) {
            if (ints[i] == Integer.MIN_VALUE) {
                return i;
            }
            ++i;
        }
        return -1L;
    }

    @Override
    public long indexOf(int integer, long fromIdx) {
        if (fromIdx >= Integer.MAX_VALUE || integer == Integer.MIN_VALUE) {
            return -1L;
        }
        if (fromIdx < 0L) {
            fromIdx = 0L;
        }
        int l = this.length;
        int[] ints = this.boolValues;
        if (integer != 0) {
            int i = (int)fromIdx;
            while (i < l) {
                if (ints[i] == 1) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = (int)fromIdx;
            while (i < l) {
                if (ints[i] == 0) {
                    return i;
                }
                ++i;
            }
        }
        return -1L;
    }
}

