/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.rj.data.RRawStore;
import org.eclipse.statet.rj.data.impl.AbstractIntegerStore;
import org.eclipse.statet.rj.data.impl.AbstractRStore;

@NonNullByDefault
public abstract class AbstractRawStore
extends AbstractRStore<Byte>
implements RRawStore {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    protected static final String toChar(byte raw) {
        return new String(new char[]{HEX_CHARS[raw >>> 4 & 0xF], HEX_CHARS[raw & 0xF]});
    }

    @Override
    public final byte getStoreType() {
        return 6;
    }

    @Override
    public final String getBaseVectorRClassName() {
        return "raw";
    }

    @Override
    public boolean getLogi(int idx) {
        return this.getRaw(idx) != 0;
    }

    @Override
    public boolean getLogi(long idx) {
        return this.getRaw(idx) != 0;
    }

    @Override
    public int getInt(int idx) {
        return this.getRaw(idx) & 0xFF;
    }

    @Override
    public int getInt(long idx) {
        return this.getRaw(idx) & 0xFF;
    }

    @Override
    public void setInt(long idx, int integer) {
        this.setRaw(idx, AbstractIntegerStore.toRaw(integer));
    }

    @Override
    public void setInt(int idx, int integer) {
        this.setRaw(idx, AbstractIntegerStore.toRaw(integer));
    }

    @Override
    public final String getChar(int idx) {
        return AbstractRawStore.toChar(this.getRaw(idx));
    }

    @Override
    public final String getChar(long idx) {
        return AbstractRawStore.toChar(this.getRaw(idx));
    }

    @Override
    public abstract @NonNull Byte[] toArray();

    @Override
    public long indexOfNA(long fromIdx) {
        return -1L;
    }
}

