/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.console;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.views.console.ConsoleMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.nico.ui.Messages;
import org.eclipse.statet.internal.nico.ui.NicoUIPlugin;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.nico.ui.console.NIConsole;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.IUpdate;

public class TerminateToolAction
extends Action
implements IUpdate {
    private IProcess process;

    public TerminateToolAction(IProcess process) {
        super(ConsoleMessages.ConsoleTerminateAction_0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.console_terminate_action_context");
        this.process = process;
        this.setToolTipText(ConsoleMessages.ConsoleTerminateAction_1);
        ImageRegistry registry = NicoUIPlugin.getInstance().getImageRegistry();
        this.setImageDescriptor(registry.getDescriptor("org.eclipse.statet.nico/image/loctool/terminate"));
        this.setDisabledImageDescriptor(registry.getDescriptor("org.eclipse.statet.nico/image/loctoold/terminate"));
        this.update();
    }

    public void update() {
        this.setEnabled(this.process.canTerminate());
    }

    public void run() {
        try {
            this.process.terminate();
            IWorkbenchPage page = UIAccess.getActiveWorkbenchPage((boolean)false);
            IConsole console = DebugUITools.getConsole((IProcess)this.process);
            if (console instanceof NIConsole) {
                NicoUITools.showConsole((NIConsole)console, page, true);
            }
        }
        catch (DebugException e) {
            int severity = e.getStatus().getSeverity();
            StatusManager.getManager().handle((IStatus)new Status(severity, "org.eclipse.statet.nico.ui", -1, Messages.TerminateToolAction_error_message, (Throwable)e), severity >= 4 ? 3 : 1);
        }
    }

    private void killTargets(IProcess process) throws DebugException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] launches = launchManager.getLaunches();
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            IProcess[] processes = launch.getProcesses();
            int j = 0;
            while (j < processes.length) {
                IProcess process2 = processes[j];
                if (process2.equals(process)) {
                    IDebugTarget[] debugTargets = launch.getDebugTargets();
                    int k = 0;
                    while (k < debugTargets.length) {
                        IDebugTarget target = debugTargets[k];
                        if (target.canTerminate()) {
                            target.terminate();
                        }
                        ++k;
                    }
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    public void dispose() {
        this.process = null;
    }
}

