/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.apps.ui.launching;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.statet.internal.r.apps.ui.RAppUIPlugin;
import org.eclipse.statet.internal.r.apps.ui.launching.AppRunner;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolQueue;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.nico.core.runtime.Queue;
import org.eclipse.statet.r.apps.ui.VariablesData;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.console.core.RWorkspace;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.tool.TmpUtils;
import org.eclipse.statet.r.nico.ICombinedRDataAdapter;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RReference;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.services.RService;
import org.eclipse.statet.rj.ts.core.AbstractRToolRunnable;
import org.eclipse.statet.rj.ts.core.RToolService;

@NonNullByDefault
public class DataLoader
extends AbstractRToolRunnable
implements SystemRunnable {
    public static final String TASK_ID = "org.eclipse.statet.r.apps/LoadVariables";
    private final AppRunner app;
    private final String expression;
    private final Job scheduleJob;
    private final AtomicInteger scheduledRetry = new AtomicInteger(0);
    private RWorkspace workspace;
    private final Set<Long> envs = new HashSet<Long>();

    public DataLoader(AppRunner app, String expression) {
        super(TASK_ID, "Load elements of R app variables");
        this.app = app;
        this.expression = expression;
        this.scheduleJob = new Job("Schedule R App Data"){

            protected IStatus run(IProgressMonitor monitor) {
                DataLoader.this.scheduleHot();
                return Status.OK_STATUS;
            }
        };
        this.scheduleJob.setSystem(true);
        this.scheduleJob.setPriority(20);
        Queue queue = this.getTool().getQueue();
        queue.addOnIdle((SystemRunnable)this, 5100);
    }

    private RProcess getTool() {
        return this.app.getTool();
    }

    public void schedule() {
        long diff;
        this.scheduledRetry.set(0);
        long started = this.app.getStartedTimestamp();
        if (started != Long.MIN_VALUE && (diff = (System.nanoTime() - started) / 100000L) < 100L) {
            this.scheduleJob.schedule(diff + 50L);
            return;
        }
        this.scheduleHot();
    }

    private void scheduleHot() {
        Queue queue = this.getTool().getQueue();
        queue.addHot((ToolRunnable)this, 1);
    }

    public void stop() {
        Queue queue = this.getTool().getQueue();
        queue.removeHot((ToolRunnable)this);
        queue.removeOnIdle((ToolRunnable)this);
    }

    public boolean canRunIn(Tool tool) {
        return tool == this.app.getTool();
    }

    protected void run(RToolService r, ProgressMonitor m) throws StatusException {
        if (!this.app.isRunning()) {
            return;
        }
        try {
            try {
                TmpUtils.Item tmpItem = TmpUtils.newItem((String)"appvars", (RService)r, (ProgressMonitor)m);
                try {
                    this.evalExpression(tmpItem, (ICombinedRDataAdapter)r, m);
                }
                finally {
                    tmpItem.disposeChecked(m);
                }
            }
            catch (StatusException | UnexpectedRDataException e) {
                ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("An error occurred when evaluating the app variables expression.");
                sb.addProp("expression", this.expression);
                RAppUIPlugin.logError(sb.toString(), e);
                this.app.setData(new VariablesData(this.expression, (org.eclipse.statet.jcommons.status.Status)new ErrorStatus("org.eclipse.statet.r.apps", 0, "Evaluation failed (internal error).", e)));
                this.envs.clear();
                ToolQueue queue = r.getTool().getQueue();
                queue.removeHot((ToolRunnable)this);
            }
        }
        finally {
            this.envs.clear();
            ToolQueue queue = r.getTool().getQueue();
            queue.removeHot((ToolRunnable)this);
        }
    }

    private void evalExpression(TmpUtils.Item tmpItem, ICombinedRDataAdapter r, ProgressMonitor m) throws UnexpectedRDataException, StatusException {
        String valueName = tmpItem.createSub("value");
        RElementName valueElementName = RElementName.create((int)17, (String)valueName);
        RElementName fqElementName = TmpUtils.createFQElementName((RElementName)valueElementName);
        CombinedRElement element = null;
        try {
            element = r.evalCombinedStruct(this.expression, 0, 0, fqElementName, m);
        }
        catch (StatusException e) {
            org.eclipse.statet.jcommons.status.Status status = e.getStatus();
            this.app.setData(new VariablesData(this.expression, org.eclipse.statet.jcommons.status.Status.newStatus((int)status.getSeverity(), (String)"org.eclipse.statet.r.apps", (int)0, (String)("Evaluation failed: " + e.getLocalizedMessage()), (Throwable)e)));
            return;
        }
        RReference ref = RDataUtils.checkRReference((RObject)element);
        if (ref.getReferencedRObjectType() == 1) {
            if (this.scheduledRetry.incrementAndGet() <= 2 && r.getController().getHotTasksState() != 0) {
                this.scheduleJob.schedule(200L);
                return;
            }
        } else {
            this.scheduledRetry.set(0);
        }
        tmpItem.set(valueName, (RObject)ref, m);
        element = r.getWorkspaceData().resolve(ref, 10, 0, m);
        if (element == null && (element = r.findCombinedStruct(valueElementName, TmpUtils.ENV_FQ_ELEMENT_NAME, false, 0, -1, m)) == null) {
            throw new UnexpectedRDataException("null");
        }
        RElementName name = RElementName.parseDefault((String)this.expression);
        if (name == null) {
            name = RElementName.create((int)16, (String)"variables");
        }
        element = ICombinedRDataAdapter.createReference((CombinedRElement)element, (RElementName)name);
        this.app.setData(new VariablesData(this.expression, (ImList<CombinedRElement>)ImCollections.newList((Object)element)));
    }
}

