/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.core.model;

import java.util.List;
import org.eclipse.statet.internal.yaml.core.model.BasicYamlSourceElement;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.yaml.core.ast.YamlAstNode;
import org.eclipse.statet.yaml.core.model.YamlElementName;
import org.eclipse.statet.yaml.core.model.YamlSourceElement;

@NonNullByDefault
public abstract class ContainerSourceElement
extends BasicYamlSourceElement {
    List<BasicYamlSourceElement> children = NO_CHILDREN;
    TextRegion nameRegion;
    private final YamlAstNode astNode;

    public ContainerSourceElement(YamlAstNode astNode) {
        this.astNode = astNode;
    }

    public TextRegion getNameSourceRange() {
        return this.nameRegion;
    }

    public TextRegion getSourceRange() {
        return this.astNode;
    }

    public boolean hasSourceChildren(@Nullable LtkModelElementFilter<? super SourceStructElement<?, ?>> filter) {
        return LtkModelUtils.hasChildren(this.children, filter);
    }

    public List<? extends SourceStructElement<?, ?>> getSourceChildren(@Nullable LtkModelElementFilter<? super SourceStructElement<?, ?>> filter) {
        return LtkModelUtils.getChildren(this.children, filter);
    }

    @Override
    public abstract @Nullable ContainerSourceElement getModelParent();

    @Override
    public boolean hasModelChildren(@Nullable LtkModelElementFilter<? super YamlSourceElement> filter) {
        return LtkModelUtils.hasChildren(this.children, filter);
    }

    @Override
    public List<? extends YamlSourceElement> getModelChildren(@Nullable LtkModelElementFilter<? super YamlSourceElement> filter) {
        return LtkModelUtils.getChildren(this.children, filter);
    }

    @Override
    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == AstNode.class) {
            return (T)((Object)this.astNode);
        }
        return super.getAdapter(adapterType);
    }

    public static class SourceContainer
    extends ContainerSourceElement {
        private final SourceUnit sourceUnit;

        public SourceContainer(SourceUnit su, YamlAstNode astNode) {
            super(astNode);
            this.sourceUnit = su;
        }

        public int getElementType() {
            return 528;
        }

        @Override
        public String getId() {
            return this.sourceUnit.getId();
        }

        @Override
        public YamlElementName getElementName() {
            ElementName elementName = this.sourceUnit.getElementName();
            if (elementName instanceof YamlElementName) {
                return (YamlElementName)elementName;
            }
            return YamlElementName.create(1, elementName.getSegmentName());
        }

        public SourceUnit getSourceUnit() {
            return this.sourceUnit;
        }

        public boolean exists() {
            SourceUnitModelInfo modelInfo = this.getSourceUnit().getModelInfo("Yaml", 0, null);
            return modelInfo != null && modelInfo.getSourceElement() == this;
        }

        public boolean isReadOnly() {
            return this.sourceUnit.isReadOnly();
        }

        public @Nullable SourceStructElement<?, ?> getSourceParent() {
            return null;
        }

        @Override
        public @Nullable ContainerSourceElement getModelParent() {
            return null;
        }
    }

    public static class StructContainer
    extends ContainerSourceElement {
        private final int type;
        private final ContainerSourceElement parent;

        public StructContainer(int type, ContainerSourceElement parent, YamlAstNode astNode) {
            super(astNode);
            this.type = type;
            this.parent = parent;
        }

        public final int getElementType() {
            return this.type;
        }

        public SourceUnit getSourceUnit() {
            return this.parent.getSourceUnit();
        }

        public boolean exists() {
            return this.parent.exists();
        }

        public boolean isReadOnly() {
            return this.parent.isReadOnly();
        }

        public ContainerSourceElement getSourceParent() {
            return this.parent;
        }

        @Override
        public ContainerSourceElement getModelParent() {
            return this.parent;
        }
    }
}

