/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolRegistryListener;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolSessionData;
import org.eclipse.statet.ecommons.ui.actions.WindowContributionsProvider;
import org.eclipse.statet.ecommons.ui.util.ImageRegistryUtil;
import org.eclipse.statet.internal.nico.ui.DecoratorsRegistry;
import org.eclipse.statet.internal.nico.ui.ToolRegistry;
import org.eclipse.statet.internal.nico.ui.actions.NicoWindowContributions;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;

public final class NicoUIPlugin
extends AbstractUIPlugin {
    public static final int INTERNAL_ERROR = 100;
    private static NicoUIPlugin instance;
    private ToolRegistry fToolRegistry;
    private WindowContributionsProvider fContributionProvider;
    private DecoratorsRegistry fUIDecoratorsRegistry;

    public static NicoUIPlugin getInstance() {
        return instance;
    }

    public static void logError(int code, String message, Throwable e) {
        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.nico.core", code, message, e));
    }

    public NicoUIPlugin() {
        instance = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fToolRegistry = new ToolRegistry();
        this.fToolRegistry.addListener(new WorkbenchToolRegistryListener(){

            public void toolSessionActivated(WorkbenchToolSessionData sessionData) {
                if (sessionData.getTool() != null) {
                    NicoUIPlugin.this.fToolRegistry.removeListener(this);
                    if (NicoUIPlugin.this.fContributionProvider == null) {
                        NicoUIPlugin.this.fContributionProvider = new NicoWindowContributions();
                    }
                }
            }

            public void toolTerminated(WorkbenchToolSessionData sessionData) {
            }
        }, null);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.fToolRegistry != null) {
                this.fToolRegistry.dispose();
                this.fToolRegistry = null;
            }
            if (this.fContributionProvider != null) {
                this.fContributionProvider.dispose();
                this.fContributionProvider = null;
            }
            if (this.fUIDecoratorsRegistry != null) {
                this.fUIDecoratorsRegistry = null;
            }
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        ImageRegistryUtil util = new ImageRegistryUtil((AbstractUIPlugin)this);
        util.register("org.eclipse.statet.nico/imgage/loctool/cancel", "loctool_16", "cancel.png");
        util.register("org.eclipse.statet.nico/image/loctoold/cancel", "loctool_16_d", "cancel.png");
        util.register("org.eclipse.statet.nico/image/loctool/pause", "loctool_16", "pause.png");
        util.register("org.eclipse.statet.nico/image/loctoold/pause", "loctool_16_d", "pause.png");
        util.register("org.eclipse.statet.nico/image/loctool/terminate", "loctool_16", "terminate.png");
        util.register("org.eclipse.statet.nico/image/loctoold/terminate", "loctool_16_d", "terminate.png");
        util.register("org.eclipse.statet.nico/image/obj/task.consolecommand", "obj_16", "task-consolecommand.png");
        util.register("org.eclipse.statet.nico/image/obj/task.commanddummy", "obj_16", "task-dummy.png");
        util.register("org.eclipse.statet.nico/image/obj/consolecommand", "obj_16", "consolecommand.png");
    }

    public ToolRegistry getToolRegistry() {
        return this.fToolRegistry;
    }

    public synchronized DecoratorsRegistry getUIDecoratorsRegistry() {
        if (this.fUIDecoratorsRegistry == null) {
            this.fUIDecoratorsRegistry = new DecoratorsRegistry();
        }
        return this.fUIDecoratorsRegistry;
    }
}

