/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.templates.config;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.statet.ecommons.preferences.ui.SettingsUpdater;
import org.eclipse.statet.ecommons.templates.TemplateVariableProcessor;
import org.eclipse.statet.ecommons.text.ui.TextViewerEditorColorUpdater;
import org.eclipse.statet.ecommons.text.ui.TextViewerJFaceUpdater;
import org.eclipse.statet.ecommons.ui.ISettingsChangedHandler;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.ltk.ui.sourceediting.ViewerSourceEditorAdapter;
import org.eclipse.statet.ltk.ui.templates.EnhTemplateStore;
import org.eclipse.statet.ltk.ui.templates.config.EditTemplateDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.text.templates.ContextTypeRegistry;
import org.eclipse.text.templates.TemplatePersistenceData;
import org.eclipse.ui.texteditor.templates.TemplatePreferencePage;

public abstract class AbstractTemplatesPreferencePage
extends TemplatePreferencePage {
    private final SourceEditorViewerConfigurator viewerConfigurator;
    private final TemplateVariableProcessor templateProcessor = new TemplateVariableProcessor();
    private final SourceEditorViewerConfigurator dialogViewerConfigurator;
    private final TemplateVariableProcessor dialogTemplateProcessor;

    public AbstractTemplatesPreferencePage() {
        this.viewerConfigurator = this.createSourceViewerConfigurator(this.templateProcessor);
        this.dialogTemplateProcessor = new TemplateVariableProcessor();
        this.dialogViewerConfigurator = this.createSourceViewerConfigurator(this.dialogTemplateProcessor);
    }

    public AbstractTemplatesPreferencePage(IPreferenceStore preferenceStore, EnhTemplateStore templateStore) {
        this();
        this.setPreferenceStore(preferenceStore);
        this.setTemplateStore(templateStore.getWorkingCopy());
        this.setContextTypeRegistry(templateStore.getContextTypeRegistry());
    }

    protected abstract SourceEditorViewerConfigurator createSourceViewerConfigurator(TemplateVariableProcessor var1);

    public void setVisible(boolean visible) {
        String title = this.getTitle();
        super.setVisible(visible);
        if (title != null && !title.isEmpty()) {
            this.setTitle(title);
        }
    }

    protected SourceViewer createViewer(Composite parent) {
        SourceViewer viewer = new SourceViewer(parent, null, 2816);
        viewer.setEditable(false);
        viewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        ViewerSourceEditorAdapter adapter = new ViewerSourceEditorAdapter(viewer, null);
        this.viewerConfigurator.setTarget(adapter);
        new SettingsUpdater((ISettingsChangedHandler)this.viewerConfigurator, viewer.getControl());
        new TextViewerJFaceUpdater((ISourceViewer)viewer, this.viewerConfigurator.getSourceViewerConfiguration().getPreferences());
        new TextViewerEditorColorUpdater(viewer, this.viewerConfigurator.getSourceViewerConfiguration().getPreferences());
        Document document = new Document();
        this.viewerConfigurator.getDocumentSetupParticipant().setup((IDocument)document);
        viewer.setDocument((IDocument)document);
        return viewer;
    }

    protected void updateViewerInput() {
        super.updateViewerInput();
        IStructuredSelection selection = (IStructuredSelection)this.getTableViewer().getSelection();
        if (selection.size() == 1) {
            TemplatePersistenceData data = (TemplatePersistenceData)selection.getFirstElement();
            Template template = data.getTemplate();
            TemplateContextType contextType = this.getContextTypeRegistry().getContextType(template.getContextTypeId());
            this.templateProcessor.setContextType(contextType);
            AbstractDocument document = (AbstractDocument)this.getViewer().getDocument();
            this.configureContext(document, contextType, this.viewerConfigurator);
        }
    }

    protected Template editTemplate(Template template, boolean edit, boolean isNameModifiable) {
        EditTemplateDialog dialog = new EditTemplateDialog(this.getShell(), template, edit, 1, this.dialogViewerConfigurator, this.dialogTemplateProcessor, (ContextTypeRegistry)this.getContextTypeRegistry(), "org.eclipse.statet.ltk.ui/templates/config"){

            @Override
            protected void configureForContext(TemplateContextType contextType) {
                super.configureForContext(contextType);
                SourceViewer sourceViewer = this.getSourceViewer();
                AbstractDocument document = (AbstractDocument)sourceViewer.getDocument();
                AbstractTemplatesPreferencePage.this.configureContext(document, contextType, this.getSourceViewerConfigurator());
            }
        };
        if (dialog.open() == 0) {
            return dialog.getTemplate();
        }
        return null;
    }

    protected abstract void configureContext(AbstractDocument var1, TemplateContextType var2, SourceEditorViewerConfigurator var3);

    protected boolean isShowFormatterSetting() {
        return false;
    }

    protected String getFormatterPreferenceKey() {
        return null;
    }
}

