/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.ui.ManagedConfigurationBlock;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.ecommons.ui.components.ButtonGroup;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.internal.ltk.ui.EditingMessages;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistCategory;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputerRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.keys.IBindingService;

public class AdvancedContentAssistConfigurationBlock
extends ManagedConfigurationBlock {
    private static BindingManager gLocalBindingManager;
    private CheckboxTableViewer defaultList;
    private CheckboxTableViewer circlingList;
    private ButtonGroup<ContentAssistCategory> circlingOrderButtons;
    private final Map<Object, Image> images = new HashMap<Object, Image>();
    private final ContentAssistComputerRegistry registry;
    private IObservableList<ContentAssistCategory> orderedCategories;
    private Command specificCommand;
    private IParameter specificParam;

    public AdvancedContentAssistConfigurationBlock(ContentAssistComputerRegistry registry, StatusChangeListener statusListener) {
        super(null, statusListener);
        this.registry = registry;
        ICommandService commandSvc = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        this.specificCommand = commandSvc.getCommand("org.eclipse.statet.ltk.commands.SpecificContentAssist");
    }

    private void prepareKeybindingInfo() {
        if (this.specificCommand == null) {
            return;
        }
        if (gLocalBindingManager == null) {
            gLocalBindingManager = new BindingManager(new ContextManager(), new CommandManager());
            IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
            gLocalBindingManager.setLocale(bindingService.getLocale());
            gLocalBindingManager.setPlatform(bindingService.getPlatform());
            Scheme[] definedSchemes = bindingService.getDefinedSchemes();
            if (definedSchemes != null) {
                try {
                    int i = 0;
                    while (i < definedSchemes.length) {
                        Scheme scheme = definedSchemes[i];
                        Scheme copy = gLocalBindingManager.getScheme(scheme.getId());
                        copy.define(scheme.getName(), scheme.getDescription(), scheme.getParentId());
                        ++i;
                    }
                }
                catch (NotDefinedException notDefinedException) {
                    // empty catch block
                }
            }
        }
        try {
            this.specificParam = this.specificCommand.getParameters()[0];
        }
        catch (Exception x) {
            this.specificCommand = null;
            this.specificParam = null;
        }
    }

    private String getDefaultKeybindingAsString() {
        ICommandService commandSvc = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        Command command = commandSvc.getCommand("org.eclipse.ui.edit.text.contentAssist.proposals");
        ParameterizedCommand pCmd = new ParameterizedCommand(command, null);
        String key = this.getKeybindingAsString(pCmd);
        return key;
    }

    private String getSpecificKeybindingAsString(ContentAssistCategory category) {
        if (gLocalBindingManager == null || category == null) {
            return null;
        }
        Parameterization[] params = new Parameterization[]{new Parameterization(this.specificParam, category.getId())};
        ParameterizedCommand pCmd = new ParameterizedCommand(this.specificCommand, params);
        return this.getKeybindingAsString(pCmd);
    }

    private String getKeybindingAsString(ParameterizedCommand command) {
        if (gLocalBindingManager == null) {
            return null;
        }
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        try {
            TriggerSequence[] binding;
            gLocalBindingManager.setBindings(bindingService.getBindings());
            Scheme activeScheme = bindingService.getActiveScheme();
            if (activeScheme != null) {
                gLocalBindingManager.setActiveScheme(activeScheme);
            }
            if ((binding = gLocalBindingManager.getActiveBindingsDisregardingContextFor(command)).length > 0) {
                return binding[0].format();
            }
            return null;
        }
        catch (NotDefinedException e) {
            return null;
        }
    }

    protected void createBlockArea(Composite pageComposite) {
        HashMap<Object, String> prefs = new HashMap<Object, String>();
        prefs.put(this.registry.getPrefDefaultDisabledCategoryIds(), this.registry.getSettingsGroupId());
        prefs.put(this.registry.getPrefCirclingOrderedCategoryIds(), this.registry.getSettingsGroupId());
        this.setupPreferenceManager(prefs);
        this.prepareKeybindingInfo();
        Composite composite = new Composite(pageComposite, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
        Link control = this.addLinkControl(composite, EditingMessages.ContentAssistAdvancedConfig_message_KeyBindingHint);
        control.setLayoutData((Object)AdvancedContentAssistConfigurationBlock.applyWrapWidth((GridData)new GridData(4, 4, true, false)));
        Label defaultKeyBindingLabel = new Label(composite, 0);
        String defaultKeyBinding = this.getDefaultKeybindingAsString();
        defaultKeyBindingLabel.setText(defaultKeyBinding != null ? NLS.bind((String)EditingMessages.ContentAssistAdvancedConfig_message_DefaultKeyBinding, (Object)defaultKeyBinding) : EditingMessages.ContentAssistAdvancedConfig_message_NoDefaultKeyBinding);
        defaultKeyBindingLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)LayoutUtils.newGroupGrid((int)1));
        group.setText(EditingMessages.ContentAssistAdvancedConfig_Default_label);
        Label label = new Label((Composite)group, 0);
        label.setText(EditingMessages.ContentAssistAdvancedConfig_DefaultTable_label);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite table = this.createDefaultTable((Composite)group);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)LayoutUtils.newGroupGrid((int)2));
        group.setText(EditingMessages.ContentAssistAdvancedConfig_Cicling_label);
        label = new Label((Composite)group, 64);
        label.setText(EditingMessages.ContentAssistAdvancedConfig_CiclingTable_label);
        label.setLayoutData((Object)AdvancedContentAssistConfigurationBlock.applyWrapWidth((GridData)new GridData(4, 4, true, false, 2, 1)));
        table = this.createCirclingTable((Composite)group);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.circlingOrderButtons = new ButtonGroup((Composite)group);
        this.circlingOrderButtons.setLayoutData((Object)new GridData(4, 4, false, true));
        this.circlingOrderButtons.addUpButton(null);
        this.circlingOrderButtons.addDownButton(null);
        this.orderedCategories = new WritableList();
        this.circlingList.setInput(this.orderedCategories);
        this.circlingOrderButtons.connectTo((StructuredViewer)this.circlingList, this.orderedCategories, null);
        ViewerUtils.scheduleStandardSelection((TableViewer)this.circlingList);
        ViewerUtils.scheduleStandardSelection((TableViewer)this.defaultList);
        this.updateControls();
    }

    protected Composite createDefaultTable(Composite parent) {
        ViewerUtils.CheckboxTableComposite composite = new ViewerUtils.CheckboxTableComposite(parent, 67588);
        this.defaultList = composite.viewer;
        composite.table.setHeaderVisible(true);
        composite.table.setLinesVisible(true);
        composite.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn column = new TableViewerColumn((TableViewer)composite.viewer, 0);
        composite.layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(3));
        column.getColumn().setText(EditingMessages.ContentAssistAdvancedConfig_ProposalKinds_label);
        column.setLabelProvider((CellLabelProvider)new CategoryKindLabelProvider());
        column = new TableViewerColumn((TableViewer)composite.viewer, 0);
        composite.layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        column.getColumn().setText(EditingMessages.ContentAssistAdvancedConfig_KeyBinding_label);
        column.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                ContentAssistCategory category = (ContentAssistCategory)cell.getElement();
                String keybindingAsString = AdvancedContentAssistConfigurationBlock.this.getSpecificKeybindingAsString(category);
                cell.setText(keybindingAsString != null ? keybindingAsString : "");
            }
        });
        return composite;
    }

    protected Composite createCirclingTable(Composite parent) {
        ViewerUtils.CheckboxTableComposite composite = new ViewerUtils.CheckboxTableComposite(parent, 67588);
        this.circlingList = composite.viewer;
        composite.table.setHeaderVisible(true);
        composite.table.setLinesVisible(true);
        composite.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn column = new TableViewerColumn((TableViewer)composite.viewer, 0);
        composite.layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        column.getColumn().setText(EditingMessages.ContentAssistAdvancedConfig_ProposalKinds_label);
        column.setLabelProvider((CellLabelProvider)new CategoryKindLabelProvider());
        return composite;
    }

    private Image getImage(ImageDescriptor imgDesc) {
        if (imgDesc == null) {
            return null;
        }
        Image img = this.images.get(imgDesc);
        if (img == null) {
            img = imgDesc.createImage(false);
            this.images.put(imgDesc, img);
        }
        return img;
    }

    public void dispose() {
        super.dispose();
        for (Image img : this.images.values()) {
            img.dispose();
        }
        this.images.clear();
    }

    protected void updateControls() {
        List<ContentAssistCategory> orderedCategories = this.registry.applyPreferences((PreferenceAccess)this, this.registry.getCopyOfCategories());
        ArrayList<ContentAssistCategory> defaultCategories = new ArrayList<ContentAssistCategory>(orderedCategories);
        Collections.sort(defaultCategories, new Comparator<ContentAssistCategory>(){
            private final Collator NAMES_COLLARTOR = Collator.getInstance();

            @Override
            public int compare(ContentAssistCategory o1, ContentAssistCategory o2) {
                return this.NAMES_COLLARTOR.compare(o1.getDisplayName(), o2.getDisplayName());
            }
        });
        this.defaultList.setInput(defaultCategories);
        for (ContentAssistCategory category : defaultCategories) {
            this.defaultList.setChecked((Object)category, category.isIncludedInDefault);
        }
        this.orderedCategories.clear();
        this.orderedCategories.addAll(orderedCategories);
        this.circlingList.refresh();
        for (ContentAssistCategory category : orderedCategories) {
            this.circlingList.setChecked((Object)category, category.isEnabledAsSeparate);
        }
        this.circlingOrderButtons.refresh();
    }

    protected void updatePreferences() {
        ArrayList<ContentAssistCategory> orderedCategories = new ArrayList<ContentAssistCategory>((Collection<ContentAssistCategory>)this.orderedCategories);
        for (ContentAssistCategory category : orderedCategories) {
            category.isIncludedInDefault = this.defaultList.getChecked((Object)category);
            category.isEnabledAsSeparate = this.circlingList.getChecked((Object)category);
        }
        Map<Preference<?>, Object> preferences = this.registry.createPreferences(orderedCategories);
        this.setPrefValues(preferences);
    }

    private class CategoryKindLabelProvider
    extends CellLabelProvider {
        private CategoryKindLabelProvider() {
        }

        public void update(ViewerCell cell) {
            ContentAssistCategory category = (ContentAssistCategory)cell.getElement();
            cell.setImage(AdvancedContentAssistConfigurationBlock.this.getImage(category.getImageDescriptor()));
            cell.setText(category.getDisplayName());
        }
    }
}

