/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.ui.IWorkbenchPart;

@NonNullByDefault
public class SourceEditorOperationHandler
extends AbstractHandler {
    private final @Nullable ISourceEditor editor;
    private final int textOperation;

    public SourceEditorOperationHandler(ISourceEditor editor, int viewerOperation) {
        this.editor = (ISourceEditor)ObjectUtils.nonNullAssert((Object)editor);
        this.textOperation = viewerOperation;
    }

    public SourceEditorOperationHandler(int viewerOperation) {
        this.editor = null;
        this.textOperation = viewerOperation;
    }

    protected int getTextOperation() {
        return this.textOperation;
    }

    protected @Nullable ISourceEditor getSourceEditor(@Nullable Object context) {
        if (this.editor != null) {
            return this.editor;
        }
        IWorkbenchPart part = WorkbenchUIUtils.getActivePart((Object)context);
        if (part == null) {
            return null;
        }
        return (ISourceEditor)part.getAdapter(ISourceEditor.class);
    }

    protected @Nullable ITextOperationTarget getOperationTarget(ISourceEditor editor) {
        ITextOperationTarget target = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
        if (target == null) {
            target = editor.getViewer().getTextOperationTarget();
        }
        return target;
    }

    public void setEnabled(@Nullable Object evaluationContext) {
        ISourceEditor editor = this.getSourceEditor(evaluationContext);
        if (editor == null || !UIAccess.isOkToUse((Viewer)editor.getViewer())) {
            this.setBaseEnabled(false);
            return;
        }
        ITextOperationTarget operationTarget = this.getOperationTarget(editor);
        this.setBaseEnabled(operationTarget != null && operationTarget.canDoOperation(this.textOperation));
    }

    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        ISourceEditor editor = this.getSourceEditor(event.getApplicationContext());
        if (editor == null || !UIAccess.isOkToUse((Viewer)editor.getViewer())) {
            return null;
        }
        ITextOperationTarget operationTarget = this.getOperationTarget(editor);
        if (operationTarget != null && operationTarget.canDoOperation(13)) {
            operationTarget.doOperation(this.textOperation);
        }
        return null;
    }
}

