/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.ecommons.text.ICharPairMatcher;
import org.eclipse.statet.ecommons.text.core.JFaceTextRegion;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.ui.TextHandlerUtil;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.ltk.ui.EditingMessages;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.model.core.DocumentModelProvider;
import org.eclipse.statet.ltk.model.core.ModelManager;
import org.eclipse.statet.ltk.model.core.ModelTypeDescriptor;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.ui.ElementInfoController;
import org.eclipse.statet.ltk.ui.ISelectionWithElementInfoListener;
import org.eclipse.statet.ltk.ui.LTKInputData;
import org.eclipse.statet.ltk.ui.ModelElementInputProvider;
import org.eclipse.statet.ltk.ui.PostSelectionCancelExtension;
import org.eclipse.statet.ltk.ui.PostSelectionWithElementInfoController;
import org.eclipse.statet.ltk.ui.sourceediting.FoldingActionGroup;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.ITextEditToolSynchronizer;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1OutlinePage;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewer;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.ltk.ui.sourceediting.SourceViewerDecorationSupport;
import org.eclipse.statet.ltk.ui.sourceediting.SourceViewerInformationControl;
import org.eclipse.statet.ltk.ui.sourceediting.StructureSelectHandler;
import org.eclipse.statet.ltk.ui.sourceediting.StructureSelectionHistory;
import org.eclipse.statet.ltk.ui.sourceediting.StructureSelectionHistoryBackHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.DeleteNextWordHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.DeletePreviousWordHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.GotoMatchingBracketHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.GotoNextWordHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.GotoPreviousWordHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.SelectNextWordHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.SelectPreviousWordHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.SourceEditorTextHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.SpecificContentAssistHandler;
import org.eclipse.statet.ltk.ui.sourceediting.actions.ToggleCommentHandler;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.templates.ITemplatesPage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class SourceEditor1
extends TextEditor
implements ISourceEditor,
SettingsChangeNotifier.ChangeListener,
IEclipsePreferences.IPreferenceChangeListener,
IShowInSource,
IShowInTargetList {
    protected static final ImList<String> ACTION_SET_CONTEXT_IDS = ImCollections.newIdentityList((Object[])new String[]{"org.eclipse.statet.ltk.contexts.EditSource1MenuSet", "org.eclipse.ui.edit.text.actionSet.presentation"});
    private static final ImList<String> CONTEXT_IDS = ImCollections.addElement(ACTION_SET_CONTEXT_IDS, (Object)"org.eclipse.statet.workbench.contexts.TextEditor");
    private final IContentType contentType;
    private final ModelTypeDescriptor modelType;
    private SourceEditorViewerConfigurator configurator;
    private boolean lazySetup;
    private SourceUnit sourceUnit;
    private ElementInfoController modelProvider;
    private PostSelectionWithElementInfoController modelPostSelection;
    protected volatile Point currentSelection;
    private SourceEditor1OutlinePage outlinePage;
    private ITemplatesPage templatesPage;
    private StructureSelectionHistory selectionHistory;
    private Preference<Boolean> foldingEnablement;
    private ProjectionSupport foldingSupport;
    private ISourceEditorAddon foldingProvider;
    private FoldingActionGroup foldingActionGroup;
    private Preference<Boolean> markOccurrencesEnablement;
    private ISourceEditorAddon markOccurrencesProvider;
    private EffectSynchonizer effectSynchronizer;
    private int effectSynchonizerCounter;
    private final CopyOnWriteIdentityListSet<IUpdate> contentUpdateables = new CopyOnWriteIdentityListSet();
    private final CopyOnWriteIdentityListSet<IHandler2> stateUpdateables = new CopyOnWriteIdentityListSet();
    private boolean inputChange;
    private int inputUpdate = Integer.MAX_VALUE;
    private ImageDescriptor imageDescriptor;

    @Deprecated
    protected static IProjectNature getProject(IEditorInput input, String projectNatureId) {
        if (input != null && input instanceof IFileEditorInput) {
            IProject project = ((IFileEditorInput)input).getFile().getProject();
            try {
                if (project != null && project.hasNature(projectNatureId)) {
                    return project.getNature(projectNatureId);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    protected static final Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    private TextRegion expand(TextRegion region, @Nullable TextRegion regionOpt) {
        return regionOpt != null ? region.expansion(regionOpt) : region;
    }

    public SourceEditor1(IContentType contentType) {
        this.contentType = contentType;
        this.modelType = Ltk.getExtContentTypeManager().getModelTypeForContentType(contentType.getId());
    }

    @Override
    public IContentType getContentType() {
        return this.contentType;
    }

    public String getModelTypeId() {
        return this.modelType.getId();
    }

    protected void initializeEditor() {
        this.configurator = this.createConfiguration();
        super.initializeEditor();
        this.setCompatibilityMode(false);
        SourceEditorViewerConfiguration configuration = this.configurator.getSourceViewerConfiguration();
        this.setPreferenceStore(configuration.getPreferences());
        this.setSourceViewerConfiguration((SourceViewerConfiguration)configuration);
        if (configuration.isSmartInsertSupported()) {
            this.configureInsertMode(SMART_INSERT, true);
        }
        PreferencesUtil.getSettingsChangeNotifier().addChangeListener((SettingsChangeNotifier.ChangeListener)this);
    }

    protected abstract SourceEditorViewerConfigurator createConfiguration();

    protected SourceEditorViewerConfigurator createInfoConfigurator() {
        return null;
    }

    protected void enableStructuralFeatures(ModelManager modelManager, Preference<Boolean> codeFoldingEnablement, Preference<Boolean> markOccurrencesEnablement) {
        this.modelProvider = new ElementInfoController(modelManager, Ltk.EDITOR_CONTEXT);
        this.foldingEnablement = codeFoldingEnablement;
        this.markOccurrencesEnablement = markOccurrencesEnablement;
    }

    protected void overwriteTitleImage(ImageDescriptor descriptor) {
        if (this.imageDescriptor == descriptor || this.imageDescriptor == null && descriptor == null) {
            return;
        }
        if (this.imageDescriptor != null) {
            JFaceResources.getResources().destroyImage(this.imageDescriptor);
        }
        this.imageDescriptor = descriptor;
        if (this.imageDescriptor != null) {
            super.setTitleImage(JFaceResources.getResources().createImage(descriptor));
        }
    }

    protected void setTitleImage(Image titleImage) {
        if (this.imageDescriptor == null) {
            super.setTitleImage(titleImage);
        }
    }

    protected Collection<String> getContextIds() {
        return CONTEXT_IDS;
    }

    protected void initializeKeyBindingScopes() {
        Collection<String> ids = this.getContextIds();
        this.setKeyBindingScopes(ids.toArray(new String[ids.size()]));
    }

    protected String[] collectContextMenuPreferencePages() {
        ArrayList<String> list = new ArrayList<String>();
        this.collectContextMenuPreferencePages(list);
        list.addAll(Arrays.asList(super.collectContextMenuPreferencePages()));
        return list.toArray(new String[list.size()]);
    }

    protected void collectContextMenuPreferencePages(List<String> pageIds) {
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        ISourceViewer sourceViewer;
        if (this.modelProvider != null && this.sourceUnit != null) {
            this.modelProvider.setInput(null);
        }
        if ((sourceViewer = this.getSourceViewer()) != null) {
            this.configurator.unconfigureTarget();
        } else {
            this.lazySetup = true;
        }
        this.inputChange = true;
        this.inputUpdate = 1;
        super.doSetInput(input);
        this.inputChange = false;
        this.inputUpdate = Integer.MAX_VALUE;
        this.initSmartInsert();
        if (input != null && this.outlinePage != null) {
            this.updateOutlinePageInput(this.outlinePage);
        }
    }

    private void initSmartInsert() {
        SourceEditorViewerConfiguration config = this.configurator.getSourceViewerConfiguration();
        if (config.isSmartInsertSupported()) {
            if (config.isSmartInsertByDefault()) {
                this.setInsertMode(SMART_INSERT);
            } else {
                this.setInsertMode(INSERT);
            }
        }
    }

    protected void setPartName(String partName) {
        super.setPartName(partName);
        if (this.inputChange) {
            if (this.inputUpdate != 1) {
                return;
            }
            this.inputUpdate = 2;
            IEditorInput input = this.getEditorInput();
            this.setupConfiguration(input);
        }
    }

    protected void handleInsertModeChanged() {
        if (this.inputChange && !this.lazySetup) {
            if (this.inputUpdate != 2) {
                return;
            }
            this.inputUpdate = 3;
            IEditorInput input = this.getEditorInput();
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (input != null && sourceViewer != null) {
                this.setupConfiguration(input, sourceViewer);
                this.configurator.configureTarget();
            }
            this.inputChange = false;
        }
        super.handleInsertModeChanged();
    }

    protected void setupConfiguration(IEditorInput newInput) {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider instanceof DocumentModelProvider) {
            SourceUnit sourceUnit = this.sourceUnit = newInput != null ? ((DocumentModelProvider)documentProvider).getWorkingCopy((Object)newInput) : null;
            if (this.modelProvider != null) {
                this.modelProvider.setInput(this.sourceUnit);
            }
        }
    }

    protected void setupConfiguration(IEditorInput newInput, ISourceViewer sourceViewer) {
        this.updateStateDependentActions();
    }

    @Override
    public SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    @Override
    public SourceViewer getViewer() {
        return (SourceViewer)super.getSourceViewer();
    }

    @Override
    public DocContentSections getDocumentContentInfo() {
        return this.configurator.getDocumentContentInfo();
    }

    @Override
    public IWorkbenchPart getWorkbenchPart() {
        return this;
    }

    @Override
    public IServiceLocator getServiceLocator() {
        return this.getSite();
    }

    @Override
    public boolean isEditable(boolean validate) {
        if (validate) {
            return this.validateEditorInputState();
        }
        return this.isEditorInputModifiable();
    }

    public ModelElementInputProvider getModelInputProvider() {
        return this.modelProvider;
    }

    public void addPostSelectionWithElementInfoListener(ISelectionWithElementInfoListener listener) {
        if (this.modelPostSelection != null) {
            this.modelPostSelection.addListener(listener);
        }
    }

    public void removePostSelectionWithElementInfoListener(ISelectionWithElementInfoListener listener) {
        if (this.modelPostSelection != null) {
            this.modelPostSelection.removeListener(listener);
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.modelProvider != null) {
            this.modelPostSelection = new PostSelectionWithElementInfoController(this.modelProvider, (IPostSelectionProvider)this.getSelectionProvider(), new PostSelectionEditorCancel());
            this.modelPostSelection.addListener(new ISelectionWithElementInfoListener(){

                @Override
                public void inputChanged() {
                }

                @Override
                public void stateChanged(LTKInputData state) {
                    TextRegion toHighlight = SourceEditor1.this.getRangeToHighlight(state);
                    if (toHighlight != null) {
                        SourceEditor1.this.setHighlightRange(toHighlight.getStartOffset(), toHighlight.getLength(), false);
                    } else {
                        SourceEditor1.this.resetHighlightRange();
                    }
                }
            });
        }
        if (this.foldingEnablement != null) {
            ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
            this.foldingSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
            SourceEditorViewerConfigurator config = this.createInfoConfigurator();
            if (config != null) {
                final IInformationControlCreator presentationCreator = new IInformationControlCreator(){

                    public IInformationControl createInformationControl(Shell parent) {
                        return new SourceViewerInformationControl(parent, SourceEditor1.this.createInfoConfigurator(), SourceEditor1.this.getOrientation());
                    }
                };
                this.foldingSupport.setHoverControlCreator(new IInformationControlCreator(){

                    public IInformationControl createInformationControl(Shell parent) {
                        return new SourceViewerInformationControl(parent, SourceEditor1.this.createInfoConfigurator(), SourceEditor1.this.getOrientation(), presentationCreator);
                    }
                });
                this.foldingSupport.setInformationPresenterControlCreator(presentationCreator);
            }
            this.foldingSupport.install();
            viewer.addProjectionListener(new IProjectionListener(){

                public void projectionEnabled() {
                    SourceEditor1.this.installFoldingProvider();
                }

                public void projectionDisabled() {
                    SourceEditor1.this.uninstallFoldingProvider();
                }
            });
            PreferenceUtils.getInstancePrefs().addPreferenceNodeListener(this.foldingEnablement.getQualifier(), (IEclipsePreferences.IPreferenceChangeListener)this);
            this.updateFoldingEnablement();
        }
        if (this.markOccurrencesEnablement != null) {
            PreferenceUtils.getInstancePrefs().addPreferenceNodeListener(this.markOccurrencesEnablement.getQualifier(), (IEclipsePreferences.IPreferenceChangeListener)this);
            this.updateMarkOccurrencesEnablement();
        }
        if (this.lazySetup) {
            this.lazySetup = false;
            this.setupConfiguration(this.getEditorInput(), this.getSourceViewer());
            this.configurator.setTarget(this);
        }
        IContextService contextService = (IContextService)this.getServiceLocator().getService(IContextService.class);
        for (String id : this.getContextIds()) {
            contextService.activateContext(id);
        }
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        SourceEditorViewer viewer = new SourceEditorViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles, this.getSourceViewerFlags());
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    protected int getSourceViewerFlags() {
        return 0;
    }

    protected IRegion getRangeToReveal(SourceUnitModelInfo modelInfo, SourceStructElement element) {
        return null;
    }

    protected TextRegion getRangeToHighlight(LTKInputData state) {
        SourceUnitModelInfo info = state.getInputInfo();
        if (info == null) {
            return null;
        }
        TextRegion region = this.getRangeToHighlight(info, state.getModelSelection());
        if (region != null) {
            return region;
        }
        AstNode root = info.getAst().getRoot();
        if (root != null) {
            ITextSelection selection = (ITextSelection)state.getSelection();
            int n = root.getChildCount();
            int i = 0;
            while (i < n) {
                AstNode child = root.getChild(i);
                if (selection.getOffset() < child.getStartOffset()) break;
                if (selection.getOffset() + selection.getLength() <= child.getEndOffset()) {
                    return child;
                }
                ++i;
            }
        }
        return null;
    }

    protected TextRegion getRangeToHighlight(SourceUnitModelInfo info, SourceStructElement element) {
        while (element != null) {
            switch (element.getElementType() & 0xF00) {
                case 1024: 
                case 1280: {
                    return this.expand(element.getSourceRange(), element.getDocumentationRange());
                }
                case 512: {
                    if ((element.getElementType() & 0xFF0) == 640) {
                        return this.expand(element.getSourceRange(), element.getDocumentationRange());
                    }
                    return null;
                }
                case 1536: {
                    if ((element.getSourceParent().getElementType() & 0xFF0) != 528) break;
                    return this.expand(element.getSourceRange(), element.getDocumentationRange());
                }
            }
            element = element.getSourceParent();
        }
        return null;
    }

    protected ISourceEditorAddon createCodeFoldingProvider() {
        return null;
    }

    private void installFoldingProvider() {
        this.uninstallFoldingProvider();
        this.foldingProvider = this.createCodeFoldingProvider();
        if (this.foldingProvider != null) {
            this.foldingProvider.install(this);
        }
    }

    private void uninstallFoldingProvider() {
        if (this.foldingProvider != null) {
            this.foldingProvider.uninstall();
            this.foldingProvider = null;
        }
    }

    private void updateFoldingEnablement() {
        if (this.foldingEnablement != null) {
            UIAccess.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Boolean enable = (Boolean)PreferenceUtils.getInstancePrefs().getPreferenceValue(SourceEditor1.this.foldingEnablement);
                    ProjectionViewer viewer = (ProjectionViewer)SourceEditor1.this.getSourceViewer();
                    if (enable != null && UIAccess.isOkToUse((Viewer)viewer) && enable.booleanValue() != viewer.isProjectionMode()) {
                        viewer.doOperation(19);
                    }
                }
            });
        }
    }

    protected ISourceEditorAddon createMarkOccurrencesProvider() {
        return null;
    }

    private void uninstallMarkOccurrencesProvider() {
        if (this.markOccurrencesProvider != null) {
            this.markOccurrencesProvider.uninstall();
            this.markOccurrencesProvider = null;
        }
    }

    private void updateMarkOccurrencesEnablement() {
        if (this.markOccurrencesEnablement != null) {
            UIAccess.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Boolean enable = (Boolean)PreferenceUtils.getInstancePrefs().getPreferenceValue(SourceEditor1.this.markOccurrencesEnablement);
                    if (enable.booleanValue()) {
                        if (SourceEditor1.this.markOccurrencesProvider == null) {
                            SourceEditor1.this.markOccurrencesProvider = SourceEditor1.this.createMarkOccurrencesProvider();
                        }
                        if (SourceEditor1.this.markOccurrencesProvider != null && SourceEditor1.this.effectSynchonizerCounter == 0) {
                            SourceEditor1.this.markOccurrencesProvider.install(SourceEditor1.this);
                        }
                    } else {
                        SourceEditor1.this.uninstallMarkOccurrencesProvider();
                    }
                }
            });
        }
    }

    protected void configureSourceViewerDecorationSupport(org.eclipse.ui.texteditor.SourceViewerDecorationSupport support) {
        super.configureSourceViewerDecorationSupport(support);
        this.configurator.configureSourceViewerDecorationSupport(support);
    }

    protected void createActions() {
        super.createActions();
        IHandlerService handlerService = (IHandlerService)this.getServiceLocator().getService(IHandlerService.class);
        StyledText textWidget = this.getViewer().getTextWidget();
        SourceEditorTextHandler handler = new GotoNextWordHandler(this);
        this.setAction("org.eclipse.ui.edit.text.goto.wordNext", null);
        TextHandlerUtil.disable(textWidget, "org.eclipse.ui.edit.text.goto.wordNext");
        handlerService.activateHandler("org.eclipse.ui.edit.text.goto.wordNext", (IHandler)handler);
        handler = new GotoPreviousWordHandler(this);
        this.setAction("org.eclipse.ui.edit.text.goto.wordPrevious", null);
        TextHandlerUtil.disable(textWidget, "org.eclipse.ui.edit.text.goto.wordNext");
        handlerService.activateHandler("org.eclipse.ui.edit.text.goto.wordPrevious", (IHandler)handler);
        handler = new SelectNextWordHandler(this);
        this.setAction("org.eclipse.ui.edit.text.select.wordNext", null);
        TextHandlerUtil.disable(textWidget, "org.eclipse.ui.edit.text.select.wordNext");
        handlerService.activateHandler("org.eclipse.ui.edit.text.select.wordNext", (IHandler)handler);
        handler = new SelectPreviousWordHandler(this);
        this.setAction("org.eclipse.ui.edit.text.select.wordPrevious", null);
        TextHandlerUtil.disable(textWidget, "org.eclipse.ui.edit.text.select.wordPrevious");
        handlerService.activateHandler("org.eclipse.ui.edit.text.select.wordPrevious", (IHandler)handler);
        handler = new DeleteNextWordHandler(this);
        this.setAction("org.eclipse.ui.edit.text.deleteNextWord", null);
        TextHandlerUtil.disable(textWidget, "org.eclipse.ui.edit.text.deleteNextWord");
        handlerService.activateHandler("org.eclipse.ui.edit.text.deleteNextWord", (IHandler)handler);
        this.markAsStateDependentHandler((IHandler2)handler, true);
        handler = new DeletePreviousWordHandler(this);
        this.setAction("org.eclipse.ui.edit.text.deletePreviousWord", null);
        TextHandlerUtil.disable(textWidget, "org.eclipse.ui.edit.text.deletePreviousWord");
        handlerService.activateHandler("org.eclipse.ui.edit.text.deletePreviousWord", (IHandler)handler);
        this.markAsStateDependentHandler((IHandler2)handler, true);
        ICharPairMatcher matcher = this.configurator.getSourceViewerConfiguration().getPairMatcher();
        if (matcher != null) {
            handlerService.activateHandler("org.eclipse.statet.ecommons.text.commands.GotoMatchingBracket", (IHandler)new GotoMatchingBracketHandler(matcher, this));
        }
        SpecificContentAssistHandler handler2 = new SpecificContentAssistHandler((ISourceEditor)this, this.configurator.getSourceViewerConfiguration().getContentAssist());
        handlerService.activateHandler("org.eclipse.statet.ltk.commands.SpecificContentAssist", (IHandler)handler2);
        handler2 = this.createToggleCommentHandler();
        if (handler2 != null) {
            handlerService.activateHandler("org.eclipse.statet.ltk.commands.ToggleComment", (IHandler)handler2);
        }
        if ((handler2 = this.createCorrectIndentHandler()) != null) {
            handlerService.activateHandler("org.eclipse.statet.ltk.commands.CorrectIndent", (IHandler)handler2);
        }
        if (this.foldingEnablement != null) {
            this.foldingActionGroup = this.createFoldingActionGroup();
        }
        if (this.modelProvider != null) {
            this.selectionHistory = new StructureSelectionHistory(this);
            handlerService.activateHandler("org.eclipse.statet.workbench.commands.SelectExpandEnclosing", (IHandler)new StructureSelectHandler.Enclosing(this, this.selectionHistory));
            handlerService.activateHandler("org.eclipse.statet.workbench.commands.SelectExpandPrevious", (IHandler)new StructureSelectHandler.Previous(this, this.selectionHistory));
            handlerService.activateHandler("org.eclipse.statet.workbench.commands.SelectExpandNext", (IHandler)new StructureSelectHandler.Next(this, this.selectionHistory));
            StructureSelectionHistoryBackHandler backHandler = new StructureSelectionHistoryBackHandler(this, this.selectionHistory);
            handlerService.activateHandler("org.eclipse.statet.workbench.commands.SelectLast", (IHandler)backHandler);
            this.selectionHistory.addUpdateListener(backHandler);
        }
    }

    protected FoldingActionGroup createFoldingActionGroup() {
        return new FoldingActionGroup((ITextEditor)this, (ProjectionViewer)this.getSourceViewer());
    }

    protected IHandler2 createToggleCommentHandler() {
        ToggleCommentHandler commentHandler = new ToggleCommentHandler(this);
        this.markAsStateDependentHandler((IHandler2)commentHandler, true);
        return commentHandler;
    }

    protected IHandler2 createCorrectIndentHandler() {
        return null;
    }

    protected void markAsContentDependentHandler(IUpdate handler, boolean mark) {
        if (mark) {
            this.contentUpdateables.add((Object)handler);
        } else {
            this.contentUpdateables.remove((Object)handler);
        }
    }

    protected void markAsStateDependentHandler(IHandler2 handler, boolean mark) {
        if (mark) {
            this.stateUpdateables.add((Object)handler);
        } else {
            this.stateUpdateables.remove((Object)handler);
        }
    }

    protected void updateContentDependentActions() {
        super.updateContentDependentActions();
        for (IUpdate handler : this.contentUpdateables.toList()) {
            handler.update();
        }
    }

    protected void updateStateDependentActions() {
        super.updateStateDependentActions();
        ImIdentityList listeners = this.stateUpdateables.toList();
        for (IHandler2 handler : listeners) {
            handler.setEnabled((Object)this);
        }
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        super.rulerContextMenuAboutToShow(menu);
        if (this.foldingActionGroup != null) {
            MenuManager foldingMenu = new MenuManager(EditingMessages.CodeFolding_label, "projection");
            menu.appendToGroup("rulers", (IContributionItem)foldingMenu);
            this.foldingActionGroup.fillMenu((IMenuManager)foldingMenu);
        }
    }

    @Override
    public ITextEditToolSynchronizer getTextEditToolSynchronizer() {
        if (this.effectSynchronizer == null) {
            this.effectSynchronizer = new EffectSynchonizer();
        }
        return this.effectSynchronizer;
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        Object adapter;
        if (adapterType == ISourceEditor.class) {
            return (T)this;
        }
        if (adapterType == ISourceViewer.class) {
            return (T)this.getSourceViewer();
        }
        if (adapterType == IContentType.class) {
            return (T)this.contentType;
        }
        if (adapterType == IContentOutlinePage.class) {
            if (this.outlinePage == null) {
                this.outlinePage = this.createOutlinePage();
                if (this.outlinePage != null) {
                    this.updateOutlinePageInput(this.outlinePage);
                }
            }
            return (T)this.outlinePage;
        }
        if (adapterType == ITemplatesPage.class) {
            if (this.templatesPage == null) {
                this.templatesPage = this.createTemplatesPage();
            }
            return (T)this.templatesPage;
        }
        if (this.foldingSupport != null && (adapter = this.foldingSupport.getAdapter(this.getSourceViewer(), adapterType)) != null) {
            return (T)adapter;
        }
        return (T)super.getAdapter(adapterType);
    }

    public void settingsChanged(final Set<String> groupIds) {
        final HashMap options = new HashMap();
        UIAccess.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                SourceEditor1.this.handleSettingsChanged(groupIds, options);
            }
        });
    }

    protected void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
        if (this.configurator != null) {
            this.configurator.handleSettingsChanged(groupIds, options);
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (this.foldingEnablement != null && event.getKey().equals(this.foldingEnablement.getKey())) {
            this.updateFoldingEnablement();
        }
        if (this.markOccurrencesEnablement != null && event.getKey().equals(this.markOccurrencesEnablement.getKey())) {
            this.updateMarkOccurrencesEnablement();
        }
    }

    protected void updateIndentSettings() {
        this.updateIndentPrefixes();
    }

    protected void handleCursorPositionChanged() {
        this.currentSelection = this.getSourceViewer().getSelectedRange();
        super.handleCursorPositionChanged();
    }

    protected SourceEditor1OutlinePage createOutlinePage() {
        return null;
    }

    protected void updateOutlinePageInput(SourceEditor1OutlinePage page) {
    }

    void handleOutlinePageClosed() {
        if (this.outlinePage != null) {
            this.outlinePage = null;
            this.resetHighlightRange();
        }
    }

    protected ITemplatesPage createTemplatesPage() {
        return null;
    }

    protected org.eclipse.ui.texteditor.SourceViewerDecorationSupport getSourceViewerDecorationSupport(ISourceViewer viewer) {
        if (this.fSourceViewerDecorationSupport == null) {
            this.fSourceViewerDecorationSupport = new SourceViewerDecorationSupport(viewer, this.getOverviewRuler(), this.getAnnotationAccess(), this.getSharedColors());
            this.configureSourceViewerDecorationSupport(this.fSourceViewerDecorationSupport);
        }
        return this.fSourceViewerDecorationSupport;
    }

    @Override
    public void selectAndReveal(int start, int length) {
        this.selectAndReveal(start, length, start, length);
    }

    protected void selectAndReveal(int selectionStart, int selectionLength, int revealStart, int revealLength) {
        if (this.modelPostSelection != null) {
            this.modelPostSelection.setUpdateOnSelection(true);
            try {
                super.selectAndReveal(selectionStart, selectionLength, revealStart, revealLength);
            }
            finally {
                this.modelPostSelection.setUpdateOnSelection(false);
            }
        } else {
            super.selectAndReveal(selectionStart, selectionLength, revealStart, revealLength);
        }
    }

    public void setSelection(ISelection selection, ISelectionWithElementInfoListener listener) {
        if (this.modelPostSelection != null && listener != null) {
            PostSelectionWithElementInfoController.IgnoreActivation activation = this.modelPostSelection.ignoreNext(listener);
            this.doSetSelection(selection);
            activation.deleteNext();
        } else {
            this.doSetSelection(selection);
        }
    }

    protected void doSetSelection(ISelection selection) {
        IStructuredSelection structured;
        if (selection instanceof IStructuredSelection && !(structured = (IStructuredSelection)selection).isEmpty()) {
            Object first = structured.getFirstElement();
            TextRegion region = null;
            if (first instanceof SourceStructElement) {
                SourceUnit sourceUnit;
                SourceUnitModelInfo modelInfo;
                SourceStructElement sourceElement = (SourceStructElement)first;
                region = sourceElement.getNameSourceRange();
                if (region == null && (region = sourceElement.getSourceRange()) != null) {
                    region = new BasicTextRegion(region.getStartOffset());
                }
                if ((modelInfo = (sourceUnit = sourceElement.getSourceUnit()).getModelInfo(this.getModelTypeId(), 0, null)) != null) {
                    TextRegion toHighlight;
                    IRegion toReveal = this.getRangeToReveal(modelInfo, sourceElement);
                    if (toReveal != null) {
                        SourceViewer viewer = this.getViewer();
                        if (viewer instanceof ITextViewerExtension5) {
                            ((ITextViewerExtension5)viewer).exposeModelRange(toReveal);
                        }
                        this.getViewer().revealRange(toReveal.getOffset(), toReveal.getLength());
                    }
                    if ((toHighlight = this.getRangeToHighlight(modelInfo, sourceElement)) != null) {
                        this.setHighlightRange(toHighlight.getStartOffset(), toHighlight.getLength(), true);
                    }
                }
            }
            if (region == null && first instanceof TextRegion) {
                region = (TextRegion)first;
            } else if (region == null && first instanceof IRegion) {
                region = JFaceTextRegion.toTextRegion((IRegion)((IRegion)first));
            }
            if (region != null) {
                this.selectAndReveal(region.getStartOffset(), region.getLength());
                return;
            }
        }
        super.doSetSelection(selection);
    }

    public void dispose() {
        if (this.modelProvider != null) {
            this.modelProvider.setInput(null);
            this.modelProvider.dispose();
        }
        PreferencesUtil.getSettingsChangeNotifier().removeChangeListener((SettingsChangeNotifier.ChangeListener)this);
        if (this.modelPostSelection != null) {
            this.modelPostSelection.dispose();
        }
        if (this.foldingEnablement != null) {
            PreferenceUtils.getInstancePrefs().removePreferenceNodeListener(this.foldingEnablement.getQualifier(), (IEclipsePreferences.IPreferenceChangeListener)this);
            this.uninstallFoldingProvider();
        }
        if (this.markOccurrencesEnablement != null) {
            PreferenceUtils.getInstancePrefs().removePreferenceNodeListener(this.markOccurrencesEnablement.getQualifier(), (IEclipsePreferences.IPreferenceChangeListener)this);
            this.uninstallMarkOccurrencesProvider();
        }
        super.dispose();
        if (this.imageDescriptor != null) {
            JFaceResources.getResources().destroyImage(this.imageDescriptor);
            this.imageDescriptor = null;
        }
        this.sourceUnit = null;
        this.modelProvider = null;
        this.modelPostSelection = null;
    }

    public ShowInContext getShowInContext() {
        Point selectionPoint = this.currentSelection;
        ISourceViewer sourceViewer = this.getSourceViewer();
        SourceUnit unit = this.getSourceUnit();
        LTKInputData selection = null;
        if (selectionPoint != null && unit != null && sourceViewer != null) {
            selection = new LTKInputData(unit, this.getSelectionProvider());
        }
        return new ShowInContext((Object)this.getEditorInput(), selection);
    }

    public String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.ui.navigator.ProjectExplorer"};
    }

    private class EffectSynchonizer
    implements ITextEditToolSynchronizer,
    ILinkedModeListener {
        private EffectSynchonizer() {
        }

        @Override
        public void install(LinkedModeModel model) {
            SourceEditor1 sourceEditor1 = SourceEditor1.this;
            sourceEditor1.effectSynchonizerCounter = sourceEditor1.effectSynchonizerCounter + 1;
            if (SourceEditor1.this.markOccurrencesProvider != null) {
                SourceEditor1.this.markOccurrencesProvider.uninstall();
            }
            model.addLinkingListener((ILinkedModeListener)this);
        }

        public void left(LinkedModeModel model, int flags) {
            SourceEditor1 sourceEditor1 = SourceEditor1.this;
            sourceEditor1.effectSynchonizerCounter = sourceEditor1.effectSynchonizerCounter - 1;
            SourceEditor1.this.updateMarkOccurrencesEnablement();
        }

        public void resume(LinkedModeModel model, int flags) {
        }

        public void suspend(LinkedModeModel model) {
        }
    }

    protected class PostSelectionEditorCancel
    extends PostSelectionCancelExtension {
        @Override
        public void init() {
            ISourceViewer viewer = SourceEditor1.this.getSourceViewer();
            if (viewer != null) {
                viewer.addTextInputListener((ITextInputListener)this);
                viewer.getDocument().addDocumentListener((IDocumentListener)this);
            }
        }

        @Override
        public void dispose() {
            ISourceViewer viewer = SourceEditor1.this.getSourceViewer();
            if (viewer != null) {
                viewer.removeTextInputListener((ITextInputListener)this);
                IDocument document = viewer.getDocument();
                if (document != null) {
                    document.removeDocumentListener((IDocumentListener)this);
                }
            }
        }
    }
}

