/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.ltk.ui.refactoring.Messages;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.refactoring.core.CommonRefactoringFactory;
import org.eclipse.statet.ltk.refactoring.core.RefactoringAdapter;
import org.eclipse.statet.ltk.refactoring.core.RefactoringDestination;
import org.eclipse.statet.ltk.ui.refactoring.AbstractElementsHandler;
import org.eclipse.statet.ltk.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.statushandlers.StatusManager;

public class PasteElementsHandler
extends AbstractElementsHandler {
    private final ISourceEditor editor;

    public PasteElementsHandler(ISourceEditor editor, CommonRefactoringFactory refactoring) {
        super(refactoring);
        this.editor = editor;
    }

    public void setEnabled(Object evaluationContext) {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = WorkbenchUIUtils.getCurrentSelection((Object)event.getApplicationContext());
        if (selection == null) {
            return null;
        }
        SourceUnit su = this.editor.getSourceUnit();
        if (su == null) {
            return null;
        }
        RefactoringDestination destination = null;
        if (selection instanceof IStructuredSelection) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            SourceUnitModelInfo modelInfo = su.getModelInfo(null, 2, (IProgressMonitor)monitor);
            if (modelInfo == null) {
                return null;
            }
            if (structuredSelection.isEmpty()) {
                destination = new RefactoringDestination((Object)modelInfo.getSourceElement());
            } else if (structuredSelection.size() == 1) {
                Object object = structuredSelection.getFirstElement();
                destination = new RefactoringDestination(object);
            }
        }
        if (destination == null || !destination.isOK()) {
            return null;
        }
        RefactoringAdapter adapter = this.refactoring.createAdapter(destination);
        if (adapter == null) {
            return null;
        }
        String code = this.getCodeFromClipboard(event);
        if (code == null || code.length() == 0) {
            return null;
        }
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        IWorkbenchPartSite site = activePart.getSite();
        Shell shell = site.getShell();
        IProgressService progressService = (IProgressService)site.getService(IProgressService.class);
        try {
            Position position = this.startInsertRefactoring(code, destination, su, adapter, shell, progressService);
            if (position != null && !position.isDeleted()) {
                this.editor.selectAndReveal(position.getOffset(), 0);
            }
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, adapter.getPluginIdentifier(), -1, Messages.PastingElements_error_message, e.getCause()), 3);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    private Position startInsertRefactoring(String code, RefactoringDestination destination, SourceUnit su, RefactoringAdapter adapter, Shell shell, IProgressService context) throws InvocationTargetException, InterruptedException {
        RefactoringProcessor processor = this.refactoring.createPasteProcessor((Object)code, destination, adapter);
        ProcessorBasedRefactoring refactoring = new ProcessorBasedRefactoring(processor);
        RefactoringExecutionHelper helper = new RefactoringExecutionHelper((Refactoring)refactoring, RefactoringCore.getConditionCheckingFailedSeverity(), shell, context);
        helper.enableInsertPosition(su);
        helper.perform(false, false);
        return helper.getInsertPosition();
    }
}

