/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.refactoring;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.statet.ecommons.ui.util.DNDUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.refactoring.core.CommonRefactoringFactory;
import org.eclipse.statet.ltk.ui.refactoring.AbstractElementsHandler;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class CopyNamesHandler
extends AbstractElementsHandler {
    public CopyNamesHandler(CommonRefactoringFactory refactoring) {
        super(refactoring);
    }

    public void setEnabled(Object context) {
        ISelection selection = WorkbenchUIUtils.getCurrentSelection((Object)context);
        if (selection != null) {
            this.setBaseEnabled(!selection.isEmpty());
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = WorkbenchUIUtils.getCurrentSelection((Object)event.getApplicationContext());
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        if (selection instanceof IStructuredSelection) {
            List elements = ((IStructuredSelection)selection).toList();
            StringBuilder sb = new StringBuilder(elements.size() * 20);
            String br = System.getProperty("line.separator");
            int i = 0;
            while (true) {
                String name;
                if ((name = this.getName(elements.get(i++))) == null) {
                    return null;
                }
                sb.append(name);
                if (i >= elements.size()) break;
                sb.append(br);
            }
            this.doCopyToClipboard(event, sb.toString());
        }
        return null;
    }

    protected String getName(Object o) {
        if (o instanceof LtkModelElement) {
            return ((LtkModelElement)o).getElementName().getDisplayName();
        }
        return null;
    }

    private void doCopyToClipboard(ExecutionEvent event, String names) {
        Clipboard clipboard = new Clipboard(UIAccess.getDisplay());
        try {
            DNDUtils.setContent((Clipboard)clipboard, (Object[])new Object[]{names}, (Transfer[])new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            if (clipboard != null && !clipboard.isDisposed()) {
                clipboard.dispose();
            }
        }
    }
}

