/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rhelp.core.RHelpKeyword;

@NonNullByDefault
public final class RHelpKeywordImpl
implements RHelpKeyword {
    private final String keyword;
    private final String description;
    private List<RHelpKeyword> nested;

    public RHelpKeywordImpl(String keyword, String description, ImList<RHelpKeyword> childs) {
        this.keyword = keyword;
        this.description = description;
        this.nested = childs;
    }

    public RHelpKeywordImpl(String keyword, String description) {
        this.keyword = keyword;
        this.description = description;
        this.nested = new ArrayList<RHelpKeyword>();
    }

    @Override
    public String getKeyword() {
        return this.keyword;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<RHelpKeyword> getNestedKeywords() {
        return this.nested;
    }

    @Override
    public @Nullable RHelpKeyword getNestedKeyword(String keyword) {
        int i = 0;
        while (i < this.nested.size()) {
            RHelpKeyword node = this.nested.get(i);
            if (node.getKeyword().equals(keyword)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public void freeze() {
        this.nested = ImCollections.toList(this.nested);
        int i = 0;
        while (i < this.nested.size()) {
            ((RHelpKeywordImpl)this.nested.get(i)).freeze();
            ++i;
        }
    }

    public int hashCode() {
        return this.keyword.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof RHelpKeyword && this.keyword.equals(((RHelpKeyword)obj).getKeyword());
    }

    public String toString() {
        return this.keyword;
    }
}

