/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.wikitext.r.ui.processing;

import java.lang.reflect.InvocationTargetException;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingConfig;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.YamlBlockWeaveParticipant;
import org.eclipse.statet.jcommons.text.core.TextLineInformation;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.model.core.LtkModels;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.yaml.core.ast.Collection;
import org.eclipse.statet.yaml.core.ast.NodeType;
import org.eclipse.statet.yaml.core.ast.SourceComponent;
import org.eclipse.statet.yaml.core.ast.Tuple;
import org.eclipse.statet.yaml.core.ast.YamlAstNode;
import org.eclipse.statet.yaml.core.ast.YamlAstVisitor;
import org.eclipse.statet.yaml.core.ast.YamlParser;

public class YamlFormatDetector {
    private static final String FAIL = "<fail>";
    private final String modelTypeId;
    private Matcher extValidator;

    public YamlFormatDetector(String modelTypeId) {
        this.modelTypeId = modelTypeId;
    }

    public String detect(IFile file, SubMonitor m) throws CoreException {
        m.beginTask(NLS.bind((String)"Detecting output format of ''{0}''...", (Object)file.getName()), 10);
        SourceUnit unit = LtkModels.getSourceUnitManager().getSourceUnit(this.modelTypeId, Ltk.PERSISTENCE_CONTEXT, (Object)file, true, (IProgressMonitor)m.newChild(1));
        try {
            SourceContent content = unit.getContent((IProgressMonitor)m.newChild(1));
            m.worked(0);
            IRegion yamlRegion = this.getYamlBlockRegion(content);
            m.worked(1);
            YamlParser yamlParser = new YamlParser();
            yamlParser.setScalarText(true);
            String code = content.getText().substring(yamlRegion.getOffset(), yamlRegion.getOffset() + yamlRegion.getLength());
            SourceComponent block = yamlParser.parse(code, null, yamlRegion.getOffset());
            String format = this.searchOutputInfo(block, code);
            String ext = this.toExtension(format);
            if (!this.isValidExt(ext)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", NLS.bind((String)"Failed to detect file extension for format ''{0}''.", (Object)format)));
            }
            String string = ext;
            return string;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.redocs.wikitext.r", 0, NLS.bind((String)"Failed to detect output format specified in doc (YAML) for ''{0}''.", (Object)file.getName()), (Throwable)e));
        }
        finally {
            unit.disconnect((IProgressMonitor)m);
        }
    }

    private IRegion getYamlBlockRegion(SourceContent content) throws BadLocationException, CoreException {
        TextLineInformation lines = content.getLines();
        YamlBlockWeaveParticipant part = new YamlBlockWeaveParticipant();
        part.reset(content);
        int lineEndOffset = lines.getStartOffset(0);
        int numLines = lines.getNumberOfLines();
        int line = 0;
        while (line < numLines) {
            int lineOffset = lineEndOffset;
            if (part.checkStartLine(lineOffset, lineEndOffset = lines.getEndOffset(line))) {
                while (++line < numLines) {
                    lineOffset = lineEndOffset;
                    if (!part.checkEndLine(lineOffset, lineEndOffset = lines.getEndOffset(line))) continue;
                    return new Region(part.getStartOffset(), lineEndOffset);
                }
            }
            ++line;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.redocs.wikitext.r", "No YAML metadata block found."));
    }

    private String searchOutputInfo(SourceComponent block, String code) throws CoreException, InvocationTargetException {
        class Searcher
        extends YamlAstVisitor {
            private String format;
            private String output;
            private String outputFormat;

            Searcher() {
            }

            public void visit(Collection node) throws InvocationTargetException {
                if (node.getYamlParent().getNodeType() == NodeType.DOC_CONTENT && node.getNodeType() == NodeType.MAP) {
                    node.acceptInYamlChildren((YamlAstVisitor)this);
                }
            }

            public void visit(Tuple node) throws InvocationTargetException {
                String key;
                if (node.getKeyNode().getNodeType() == NodeType.SCALAR && (key = node.getKeyNode().getText()) != null) {
                    if (key.equals("format")) {
                        if (this.format == null) {
                            if (node.getValueNode().getNodeType() == NodeType.SCALAR) {
                                this.format = node.getValueNode().getText();
                            }
                            if (this.format == null) {
                                this.format = YamlFormatDetector.FAIL;
                            }
                        }
                    } else if (key.equals("output") && this.output == null) {
                        switch (node.getValueNode().getNodeType()) {
                            case SCALAR: {
                                this.output = node.getValueNode().getText();
                                break;
                            }
                            case MAP: {
                                YamlAstNode firstOutput;
                                if (!node.getValueNode().hasChildren() || (firstOutput = node.getValueNode().getChild(0)).getNodeType() != NodeType.MAP_ENTRY) break;
                                this.checkOutputEntry((Tuple)firstOutput);
                                break;
                            }
                        }
                        if (this.output == null) {
                            this.output = YamlFormatDetector.FAIL;
                        }
                    }
                }
            }

            private void checkOutputEntry(Tuple outputEntry) {
                if (outputEntry.getKeyNode().getNodeType() == NodeType.SCALAR) {
                    this.output = outputEntry.getKeyNode().getText();
                }
                if (outputEntry.getValueNode().getNodeType() == NodeType.MAP) {
                    Collection outputConfig = (Collection)outputEntry.getValueNode();
                    int i = 0;
                    while (i < outputConfig.getChildCount()) {
                        Tuple outputConfigEntry;
                        YamlAstNode iChild = outputConfig.getChild(i);
                        if (iChild.getNodeType() == NodeType.MAP_ENTRY && (outputConfigEntry = (Tuple)iChild).getKeyNode().getNodeType() == NodeType.SCALAR && outputConfigEntry.getKeyNode().getText().equals("format") && outputConfigEntry.getValueNode().getNodeType() == NodeType.SCALAR) {
                            this.outputFormat = outputConfigEntry.getValueNode().getText();
                        }
                        ++i;
                    }
                }
            }
        }
        Searcher searcher = new Searcher();
        block.acceptInYaml((YamlAstVisitor)searcher);
        if (searcher.format != null) {
            if (searcher.format == FAIL) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", "Unexpected data for 'format'.\nYAML code:\n" + code));
            }
            return searcher.format;
        }
        if (searcher.output != null) {
            if (searcher.outputFormat != null && this.isValidExt(this.toExtension(searcher.outputFormat))) {
                return searcher.outputFormat;
            }
            if (searcher.output == FAIL) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", "Unexpected data for 'output'.\nYAML code:\n" + code));
            }
            return searcher.output;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", "No 'format' or 'output' entry found.\nYAML code:\n" + code));
    }

    private String toExtension(String format) {
        int idx = format.lastIndexOf(58);
        if (idx >= 0) {
            format = format.substring(idx + 1);
        }
        if ((idx = format.indexOf(95)) >= 0) {
            format = format.substring(0, idx);
        }
        switch (format) {
            case "native": {
                return "hs";
            }
            case "plain": {
                return "txt";
            }
            case "markdown": {
                return "md";
            }
            case "mediawiki": {
                return "mediawiki";
            }
            case "textile": {
                return "textile";
            }
            case "asciidoc": {
                return "asciidoc";
            }
            case "html": 
            case "html5": {
                return "html";
            }
            case "beamer": 
            case "pdf": 
            case "latex": {
                return "pdf";
            }
            case "context": {
                return "tex";
            }
            case "texinfo": {
                return "texi";
            }
            case "docbook": {
                return "dbk";
            }
            case "opendocument": 
            case "odt": {
                return "odt";
            }
            case "docx": 
            case "word": {
                return "docx";
            }
            case "rtf": {
                return "rtf";
            }
            case "epub": 
            case "epub3": {
                return "epub";
            }
            case "dzslides": 
            case "slideous": 
            case "revealjs": 
            case "s5": 
            case "slidy": {
                return "html";
            }
        }
        return format;
    }

    private boolean isValidExt(String ext) {
        if (this.extValidator == null) {
            this.extValidator = DocProcessingConfig.VALID_EXT_PATTERN.matcher(ext);
        } else {
            this.extValidator.reset(ext);
        }
        return this.extValidator.matches();
    }
}

