/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.util;

import org.eclipse.ui.dialogs.SearchPattern;

public class RNameSearchPattern
extends SearchPattern {
    private final StringBuilder sb = new StringBuilder();
    private boolean fuzzy;
    private boolean fuzzyLowerCase;

    public RNameSearchPattern() {
        super(163);
    }

    public void setPattern(String stringPattern) {
        this.fuzzy = false;
        this.fuzzyLowerCase = false;
        if (!stringPattern.isEmpty() && stringPattern.indexOf(95) < 0 && stringPattern.indexOf(46) < 0 && stringPattern.indexOf(42) < 0 && stringPattern.indexOf(63) < 0) {
            this.fuzzy = true;
            char c = stringPattern.charAt(0);
            if (Character.isLowerCase(c)) {
                this.fuzzyLowerCase = true;
                stringPattern = String.valueOf(Character.toUpperCase(c)) + stringPattern.substring(1);
            }
        }
        super.setPattern(stringPattern);
    }

    private String prepareFuzzy(String text) {
        this.sb.setLength(0);
        boolean innerSep = this.fuzzyLowerCase;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '_' || c == '.') {
                innerSep = true;
            } else if (innerSep) {
                innerSep = false;
                this.sb.append(Character.toUpperCase(c));
            } else {
                this.sb.append(c);
            }
            ++i;
        }
        return this.sb.toString();
    }

    public boolean matches(String text) {
        if (this.fuzzy) {
            text = this.prepareFuzzy(text);
        }
        return super.matches(text);
    }
}

