/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import java.util.function.Consumer;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class RElementVariableStore {
    private static final int SEGMENT_LENGTH = 1000;
    private final long length;
    private final @Nullable RElementVariable[] @Nullable [] arrays;

    public RElementVariableStore(long length) {
        this.length = length;
        this.arrays = new RElementVariable[this.length > 0L ? (int)((this.length - 1L) / 1000L) + 1 : 0][];
    }

    public void set(long idx, RElementVariable value) {
        int idx0 = (int)(idx / 1000L);
        RElementVariable[] segment = this.arrays[idx0];
        if (segment == null) {
            this.arrays[idx0] = new RElementVariable[idx0 == this.arrays.length - 1 ? (int)((this.length - 1L) % 1000L) + 1 : 1000];
            segment = this.arrays[idx0];
        }
        int idx1 = (int)(idx % 1000L);
        segment[idx1] = value;
    }

    public @Nullable RElementVariable get(long idx) {
        int idx0 = (int)(idx / 1000L);
        RElementVariable[] segment = this.arrays[idx0];
        return segment != null ? segment[(int)(idx % 1000L)] : null;
    }

    public @Nullable RElementVariable clear(long idx) {
        int idx0 = (int)(idx / 1000L);
        RElementVariable[] segment = this.arrays[idx0];
        if (segment == null) {
            return null;
        }
        int idx1 = (int)(idx % 1000L);
        RElementVariable value = segment[idx1];
        segment[idx1] = null;
        return value;
    }

    public void forEachSet(Consumer<RElementVariable> action) {
        int idx0 = 0;
        while (idx0 < this.arrays.length) {
            @Nullable RElementVariable[] segment = this.arrays[idx0];
            if (segment != null) {
                int idx1 = 0;
                while (idx1 < segment.length) {
                    RElementVariable value = segment[idx1];
                    if (value != null) {
                        action.accept(value);
                    }
                    ++idx1;
                }
            }
            ++idx0;
        }
    }
}

