/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.status;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.util.StatusPrinter;

@NonNullByDefault
public class StatusException
extends Exception {
    private static final long serialVersionUID = 1L;
    private static final StatusPrinter PRINTER = new StatusPrinter();
    private final Status status;

    public StatusException(Status status) {
        super(status.getMessage(), status.getException());
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream output) {
        PrintStream printStream = output;
        synchronized (printStream) {
            super.printStackTrace(output);
            if (this.status.isMultiStatus()) {
                output.println("Contains:");
                PRINTER.print(this.status.getChildren(), output);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter output) {
        PrintWriter printWriter = output;
        synchronized (printWriter) {
            super.printStackTrace(output);
            if (this.status.isMultiStatus()) {
                output.println("Contains:");
                PRINTER.print(this.status.getChildren(), output);
            }
        }
    }
}

