/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.tickupdate;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.waltable.command.AbstractLayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.config.IEditableRule;
import org.eclipse.statet.ecommons.waltable.coordinate.PositionCoordinate;
import org.eclipse.statet.ecommons.waltable.data.validate.IDataValidator;
import org.eclipse.statet.ecommons.waltable.edit.EditConfigAttributes;
import org.eclipse.statet.ecommons.waltable.edit.EditUtils;
import org.eclipse.statet.ecommons.waltable.edit.UpdateDataCommand;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.selection.SelectionLayer;
import org.eclipse.statet.ecommons.waltable.style.DisplayMode;
import org.eclipse.statet.ecommons.waltable.tickupdate.ITickUpdateHandler;
import org.eclipse.statet.ecommons.waltable.tickupdate.TickUpdateCommand;
import org.eclipse.statet.ecommons.waltable.tickupdate.TickUpdateConfigAttributes;
import org.eclipse.statet.internal.ecommons.waltable.WaLTablePlugin;

public class TickUpdateCommandHandler
extends AbstractLayerCommandHandler<TickUpdateCommand> {
    private final SelectionLayer selectionLayer;

    public TickUpdateCommandHandler(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    @Override
    public boolean doCommand(TickUpdateCommand command) {
        List<PositionCoordinate> selectedPositions = this.selectionLayer.getSelectedCellPositions();
        IConfigRegistry configRegistry = command.getConfigRegistry();
        if (selectedPositions.size() > 1) {
            if (EditUtils.allCellsEditable(this.selectionLayer, configRegistry) && EditUtils.isEditorSame(this.selectionLayer, configRegistry) && EditUtils.isConverterSame(this.selectionLayer, configRegistry)) {
                for (PositionCoordinate position : selectedPositions) {
                    this.updateSingleCell(command, position);
                }
            }
        } else {
            this.updateSingleCell(command, this.selectionLayer.getLastSelectedCellPosition());
        }
        return true;
    }

    private void updateSingleCell(TickUpdateCommand command, PositionCoordinate selectedPosition) {
        ILayerCell cell = this.selectionLayer.getCellByPosition(selectedPosition.columnPosition, selectedPosition.rowPosition);
        IConfigRegistry configRegistry = command.getConfigRegistry();
        IEditableRule editableRule = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, DisplayMode.EDIT, cell.getConfigLabels().getLabels());
        IDataValidator validator = configRegistry.getConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, DisplayMode.EDIT, cell.getConfigLabels().getLabels());
        if (editableRule.isEditable(cell, configRegistry)) {
            Object newValue = this.getNewCellValue(command, cell);
            try {
                if (validator == null || validator.validate(cell, configRegistry, newValue)) {
                    this.selectionLayer.doCommand(new UpdateDataCommand(this.selectionLayer, selectedPosition.columnPosition, selectedPosition.rowPosition, newValue));
                } else {
                    WaLTablePlugin.log((IStatus)new Status(2, "org.eclipse.statet.ecommons.waltable.core", "Tick update failed for cell at " + selectedPosition + " and value " + newValue + ". New value is not valid!"));
                }
            }
            catch (Exception e) {
                WaLTablePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.waltable.core", "Tick update failed for cell at " + selectedPosition + " and value " + newValue + ". " + e.getLocalizedMessage()));
            }
        }
    }

    private Object getNewCellValue(TickUpdateCommand command, ILayerCell cell) {
        ITickUpdateHandler tickUpdateHandler = command.getConfigRegistry().getConfigAttribute(TickUpdateConfigAttributes.UPDATE_HANDLER, DisplayMode.EDIT, cell.getConfigLabels().getLabels());
        Object dataValue = cell.getDataValue(0, null);
        if (tickUpdateHandler != null && tickUpdateHandler.isApplicableFor(dataValue)) {
            if (command.isIncrement()) {
                return tickUpdateHandler.getIncrementedValue(dataValue);
            }
            return tickUpdateHandler.getDecrementedValue(dataValue);
        }
        return dataValue;
    }

    @Override
    public Class<TickUpdateCommand> getCommandClass() {
        return TickUpdateCommand.class;
    }
}

