/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.sort.painter;

import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.painter.cell.CellPainterWrapper;
import org.eclipse.statet.ecommons.waltable.painter.cell.ICellPainter;
import org.eclipse.statet.ecommons.waltable.painter.cell.ImagePainter;
import org.eclipse.statet.ecommons.waltable.painter.cell.TextPainter;
import org.eclipse.statet.ecommons.waltable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.statet.ecommons.waltable.ui.util.CellEdgeEnum;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.graphics.Image;

public class SortableHeaderTextPainter
extends CellPainterWrapper {
    public SortableHeaderTextPainter() {
        this(new TextPainter());
    }

    public SortableHeaderTextPainter(ICellPainter interiorPainter) {
        this(interiorPainter, CellEdgeEnum.RIGHT);
    }

    public SortableHeaderTextPainter(ICellPainter interiorPainter, CellEdgeEnum cellEdge) {
        this(interiorPainter, cellEdge, new SortIconPainter(true));
    }

    public SortableHeaderTextPainter(ICellPainter interiorPainter, CellEdgeEnum cellEdge, ICellPainter decoratorPainter) {
        this.setWrappedPainter(new CellPainterDecorator(interiorPainter, cellEdge, decoratorPainter));
    }

    public SortableHeaderTextPainter(ICellPainter interiorPainter, CellEdgeEnum cellEdge, boolean paintBg, long spacing, boolean paintDecorationDependent) {
        SortIconPainter sortPainter = new SortIconPainter(paintBg);
        CellPainterDecorator painter = new CellPainterDecorator(interiorPainter, cellEdge, spacing, sortPainter, paintDecorationDependent);
        this.setWrappedPainter(painter);
    }

    public SortableHeaderTextPainter(ICellPainter interiorPainter, boolean paintBg, boolean interiorPainterToSpanFullWidth) {
        SortIconPainter sortPainter = new SortIconPainter(paintBg);
        CellPainterDecorator painter = new CellPainterDecorator(interiorPainter, CellEdgeEnum.RIGHT, 0L, sortPainter);
        painter.setPaintDecorationDependent(!interiorPainterToSpanFullWidth);
        this.setWrappedPainter(painter);
    }

    protected static class SortIconPainter
    extends ImagePainter {
        public SortIconPainter(boolean paintBg) {
            super(null, paintBg);
        }

        @Override
        protected Image getImage(ILayerCell cell, IConfigRegistry configRegistry) {
            Image icon = null;
            if (this.isSortedAscending(cell)) {
                icon = this.selectDownImage(this.getSortSequence(cell));
            } else if (this.isSortedDescending(cell)) {
                icon = this.selectUpImage(this.getSortSequence(cell));
            }
            return icon;
        }

        private boolean isSortedAscending(ILayerCell cell) {
            return cell.getConfigLabels().hasLabel("SORT_UP");
        }

        private boolean isSortedDescending(ILayerCell cell) {
            return cell.getConfigLabels().hasLabel("SORT_DOWN");
        }

        private int getSortSequence(ILayerCell cell) {
            for (String configLabel : cell.getConfigLabels().getLabels()) {
                if (!configLabel.startsWith("SORT_SEQ_")) continue;
                return Integer.parseInt(configLabel.substring("SORT_SEQ_".length()));
            }
            return 0;
        }

        private Image selectUpImage(int sortSequence) {
            switch (sortSequence) {
                case 0: {
                    return GUIHelper.getImage("up_0");
                }
                case 1: {
                    return GUIHelper.getImage("up_1");
                }
                case 2: {
                    return GUIHelper.getImage("up_2");
                }
            }
            return GUIHelper.getImage("up_2");
        }

        private Image selectDownImage(int sortSequence) {
            switch (sortSequence) {
                case 0: {
                    return GUIHelper.getImage("down_0");
                }
                case 1: {
                    return GUIHelper.getImage("down_1");
                }
                case 2: {
                    return GUIHelper.getImage("down_2");
                }
            }
            return GUIHelper.getImage("down_2");
        }
    }
}

