/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.layer.cell;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.layer.cell.AbstractOverrider;
import org.eclipse.statet.ecommons.waltable.persistence.IPersistable;

public class ColumnOverrideLabelAccumulator
extends AbstractOverrider
implements IPersistable {
    public static final String PERSISTENCE_KEY = ".columnOverrideLabelAccumulator";
    private final ILayer layer;

    public ColumnOverrideLabelAccumulator(ILayer layer) {
        this.layer = layer;
    }

    @Override
    public void accumulateConfigLabels(LabelStack configLabels, long columnPosition, long rowPosition) {
        long columnIndex = this.layer.getDim(Orientation.HORIZONTAL).getPositionId(columnPosition, columnPosition);
        List<String> overrides = this.getOverrides(Long.valueOf(columnIndex));
        if (overrides != null) {
            for (String configLabel : overrides) {
                configLabels.addLabel(configLabel);
            }
        }
    }

    public void registerColumnOverrides(long columnIndex, String ... configLabels) {
        super.registerOverrides((Serializable)Long.valueOf(columnIndex), configLabels);
    }

    public void registerColumnOverridesOnTop(long columnIndex, String ... configLabels) {
        super.registerOverridesOnTop(Long.valueOf(columnIndex), configLabels);
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        Map<Serializable, List<String>> overrides = this.getOverrides();
        for (Map.Entry<Serializable, List<String>> entry : overrides.entrySet()) {
            StringBuilder strBuilder = new StringBuilder();
            for (String columnLabel : entry.getValue()) {
                strBuilder.append(columnLabel);
                strBuilder.append(",");
            }
            String propertyValue = strBuilder.toString();
            if (propertyValue.endsWith(",")) {
                propertyValue = propertyValue.substring(0, propertyValue.length() - 1);
            }
            String propertyKey = String.valueOf(prefix) + PERSISTENCE_KEY + "." + entry.getKey();
            properties.setProperty(propertyKey, propertyValue);
        }
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        Set<Object> keySet = properties.keySet();
        for (Object key : keySet) {
            String keyString = (String)key;
            if (!keyString.contains(PERSISTENCE_KEY)) continue;
            String labelsFromPropertyValue = properties.getProperty(keyString).trim();
            String columnIndexFromKey = keyString.substring(keyString.lastIndexOf(".") + 1);
            this.registerColumnOverrides(Long.parseLong(columnIndexFromKey), labelsFromPropertyValue.split(","));
        }
    }
}

