/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import java.util.Collections;
import java.util.List;
import org.eclipse.statet.ecommons.collections.FastList;
import org.eclipse.statet.ecommons.graphics.core.ColorDef;
import org.eclipse.statet.ecommons.graphics.core.ColorRefDef;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.components.IObjValueListener;
import org.eclipse.statet.ecommons.ui.components.IObjValueWidget;
import org.eclipse.statet.ecommons.ui.components.ObjValueEvent;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class ColorPalette
extends Canvas
implements IObjValueWidget<ColorDef> {
    private static final LineAttributes SELECTION1 = new LineAttributes(1.0f, 1, 1, 6, new float[]{1.0f, 1.0f}, 0.0f, 10.0f);
    private static final LineAttributes SELECTION2 = new LineAttributes(1.0f, 1, 1, 6, new float[]{1.0f, 1.0f}, 1.0f, 10.0f);
    private static final Color G_BACKGROUND = SharedUIResources.getColors().getColor("graphics.background");
    private static final ColorDef G_BACKGROUND_DEF = new ColorDef(G_BACKGROUND.getRed(), G_BACKGROUND.getGreen(), G_BACKGROUND.getBlue());
    private final int fSize;
    private boolean fHasFocus;
    private List<? extends ColorDef> fColors = Collections.emptyList();
    private int fSelectionIdx = -1;
    private int fCursorIdx = 0;
    private int fColumnCount;
    private int fVisibleRowCount;
    private final FastList<IObjValueListener<ColorDef>> fValueListeners = new FastList(IObjValueListener.class);

    public ColorPalette(Composite parent) {
        super(parent, 512);
        this.fSize = 8 + LayoutUtils.defaultHSpacing() * 2;
        this.getVerticalBar().setVisible(true);
        SWTListener listener = new SWTListener();
        this.addPaintListener(listener);
        this.addListener(11, listener);
        this.addListener(15, listener);
        this.addListener(16, listener);
        this.getVerticalBar().addListener(13, (Listener)listener);
        this.addListener(37, listener);
        this.addListener(8, listener);
        this.addListener(3, listener);
        this.addListener(32, listener);
        this.addListener(1, listener);
        this.addListener(31, listener);
        this.updateScroll();
    }

    public void setColors(List<? extends ColorDef> colors) {
        this.fColors = colors;
        this.updateScroll();
        this.checkCursor();
    }

    private void checkCursor() {
        if (this.fColors.isEmpty()) {
            this.fCursorIdx = -1;
            return;
        }
        if (this.fCursorIdx < 0) {
            this.fCursorIdx = this.getVerticalBar().getSelection() * this.fColumnCount;
        }
        if (this.fCursorIdx >= this.fColors.size()) {
            this.fCursorIdx = this.fColors.size() - 1;
        }
        if (this.fColumnCount == 0) {
            return;
        }
        int row = this.fCursorIdx / this.fColumnCount;
        int topRow = this.getVerticalBar().getSelection();
        if (row < topRow) {
            this.getVerticalBar().setSelection(row);
        } else if (row >= topRow + this.fVisibleRowCount) {
            this.getVerticalBar().setSelection(row - this.fVisibleRowCount + 1);
        }
    }

    private void updateScroll() {
        ScrollBar bar = this.getVerticalBar();
        int count = this.fColors.size();
        Rectangle clientArea = this.getClientArea();
        this.fColumnCount = (clientArea.width - 1) / this.fSize;
        if (count == 0 || this.fColumnCount == 0) {
            bar.setEnabled(false);
            bar.setValues(0, 0, 1, 1, 1, 1);
            return;
        }
        int rows = (count + this.fColumnCount - 1) / this.fColumnCount;
        this.fVisibleRowCount = (clientArea.height - 1) / this.fSize;
        if (rows <= this.fVisibleRowCount) {
            bar.setEnabled(false);
            bar.setValues(0, 0, 1, 1, 1, 1);
            return;
        }
        bar.setEnabled(true);
        bar.setValues(0, 0, rows, this.fVisibleRowCount, 1, this.fVisibleRowCount);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = wHint >= 0 ? wHint : 1 + this.fSize * 10;
        int height = hHint >= 0 ? hHint : 1 + this.fSize * 9;
        Rectangle trimmed = this.computeTrim(0, 0, width, height);
        return new Point(trimmed.width, trimmed.height);
    }

    public boolean setFocus() {
        return this.forceFocus();
    }

    public int getColorIdx(int x, int y) {
        int count = this.fColors.size();
        if (count == 0 || this.fColumnCount == 0) {
            return -1;
        }
        int idx = (this.getVerticalBar().getSelection() + (y - 1) / this.fSize) * this.fColumnCount;
        return (idx += (x - 1) / this.fSize) < count ? idx : -1;
    }

    @Override
    public Control getControl() {
        return this;
    }

    @Override
    public Class<ColorDef> getValueType() {
        return ColorDef.class;
    }

    @Override
    public void addValueListener(IObjValueListener<ColorDef> listener) {
        this.fValueListeners.add(listener);
    }

    @Override
    public void removeValueListener(IObjValueListener<ColorDef> listener) {
        this.fValueListeners.remove(listener);
    }

    private boolean doSetColor(int idx, int time, int flags) {
        ColorDef newValue;
        ColorDef oldValue = this.fSelectionIdx >= 0 ? this.fColors.get(this.fSelectionIdx) : null;
        ColorDef colorDef = newValue = idx >= 0 ? this.fColors.get(idx) : null;
        if (oldValue == newValue && flags == 0) {
            return false;
        }
        IObjValueListener[] listeners = (IObjValueListener[])this.fValueListeners.toArray();
        ObjValueEvent<ColorDef> event = new ObjValueEvent<ColorDef>(this, time, 0, oldValue, newValue, flags);
        this.fSelectionIdx = idx;
        int i = 0;
        while (i < listeners.length) {
            event.newValue = newValue;
            listeners[i].valueChanged(event);
            ++i;
        }
        if (!this.isDisposed()) {
            this.redraw();
        }
        return true;
    }

    @Override
    public ColorDef getValue(int idx) {
        if (idx != 0) {
            throw new IllegalArgumentException("idx: " + idx);
        }
        return this.fSelectionIdx >= 0 ? this.fColors.get(this.fSelectionIdx) : null;
    }

    @Override
    public void setValue(int idx, ColorDef value) {
        if (idx != 0) {
            throw new IllegalArgumentException("idx: " + idx);
        }
        if (value != null) {
            ColorDef c;
            int i = 0;
            while (i < this.fColors.size()) {
                c = this.fColors.get(i);
                if (c.equals((Object)value)) {
                    this.setValue(i);
                    return;
                }
                ++i;
            }
            if (value instanceof ColorRefDef) {
                ColorDef ref = ((ColorRefDef)value).getRef();
                int i2 = 0;
                while (i2 < this.fColors.size()) {
                    ColorDef c2 = this.fColors.get(i2);
                    if (c2.equals((Object)ref)) {
                        this.setValue(i2);
                        return;
                    }
                    ++i2;
                }
            }
            i = 0;
            while (i < this.fColors.size()) {
                c = this.fColors.get(i);
                if (c.equalsRGB(value)) {
                    this.setValue(i);
                    return;
                }
                ++i;
            }
        }
        this.setValue(-1);
    }

    public void setValue(int idx) {
        this.fCursorIdx = idx;
        this.checkCursor();
        if (this.fSelectionIdx != idx && this.doSetColor(idx, 0, 0)) {
            return;
        }
        this.redraw();
    }

    public void setCursor(int idx, ColorDef value) {
        if (idx != 0) {
            throw new IllegalArgumentException("idx: " + idx);
        }
        int colorIdx = -1;
        int i = 0;
        while (i < this.fColors.size()) {
            ColorDef c = this.fColors.get(i);
            if (c.equals((Object)value)) {
                colorIdx = i;
                break;
            }
            if (colorIdx == -1 && c.equalsRGB(value)) {
                colorIdx = i;
            }
            ++i;
        }
        if (colorIdx >= 0) {
            this.fCursorIdx = colorIdx;
            this.checkCursor();
            this.redraw();
        }
    }

    private class SWTListener
    implements Listener,
    PaintListener {
        private boolean fDoubleClick;

        private SWTListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 11: {
                    ColorPalette.this.updateScroll();
                    ColorPalette.this.checkCursor();
                    return;
                }
                case 15: {
                    ColorPalette.this.fHasFocus = true;
                    ColorPalette.this.redraw();
                    return;
                }
                case 16: {
                    ColorPalette.this.fHasFocus = false;
                    ColorPalette.this.redraw();
                    return;
                }
                case 13: {
                    ColorPalette.this.redraw();
                    return;
                }
                case 32: {
                    int idx = ColorPalette.this.getColorIdx(event.x, event.y);
                    if (idx >= 0) {
                        ColorPalette.this.setToolTipText(((ColorDef)ColorPalette.this.fColors.get(idx)).toString());
                    } else {
                        ColorPalette.this.setToolTipText("");
                    }
                    return;
                }
                case 3: {
                    this.fDoubleClick = false;
                    int idx = ColorPalette.this.getColorIdx(event.x, event.y);
                    if (idx >= 0) {
                        ColorPalette.this.fCursorIdx = idx;
                        if (!ColorPalette.this.doSetColor(idx, event.time, 0)) {
                            this.fDoubleClick = true;
                            ColorPalette.this.redraw();
                        }
                    }
                    return;
                }
                case 8: {
                    if (this.fDoubleClick) {
                        this.fDoubleClick = false;
                        int idx = ColorPalette.this.getColorIdx(event.x, event.y);
                        if (idx >= 0 && idx == ColorPalette.this.fSelectionIdx) {
                            ColorPalette.this.fCursorIdx = idx;
                            if (!ColorPalette.this.doSetColor(idx, event.time, 1)) {
                                ColorPalette.this.redraw();
                            }
                        }
                    }
                    return;
                }
                case 1: {
                    switch (event.keyCode) {
                        case 0x1000003: {
                            if (event.stateMask == 0) {
                                ColorPalette colorPalette = ColorPalette.this;
                                colorPalette.fCursorIdx = colorPalette.fCursorIdx - 1;
                                ColorPalette.this.checkCursor();
                                ColorPalette.this.redraw();
                            }
                            return;
                        }
                        case 0x1000004: {
                            if (event.stateMask == 0) {
                                ColorPalette colorPalette = ColorPalette.this;
                                colorPalette.fCursorIdx = colorPalette.fCursorIdx + 1;
                                ColorPalette.this.checkCursor();
                                ColorPalette.this.redraw();
                            }
                            return;
                        }
                        case 0x1000001: {
                            if (event.stateMask == 0 && ColorPalette.this.fCursorIdx >= ColorPalette.this.fColumnCount) {
                                ColorPalette colorPalette = ColorPalette.this;
                                colorPalette.fCursorIdx = colorPalette.fCursorIdx - ColorPalette.this.fColumnCount;
                                ColorPalette.this.checkCursor();
                                ColorPalette.this.redraw();
                            }
                            return;
                        }
                        case 0x1000002: {
                            if (event.stateMask == 0 && ColorPalette.this.fCursorIdx < ColorPalette.this.fColors.size() - ColorPalette.this.fColumnCount) {
                                ColorPalette colorPalette = ColorPalette.this;
                                colorPalette.fCursorIdx = colorPalette.fCursorIdx + ColorPalette.this.fColumnCount;
                                ColorPalette.this.checkCursor();
                                ColorPalette.this.redraw();
                            }
                            return;
                        }
                        case 13: {
                            ColorPalette.this.doSetColor(ColorPalette.this.fCursorIdx, event.time, 1);
                            return;
                        }
                        case 32: {
                            ColorPalette.this.doSetColor(ColorPalette.this.fCursorIdx, event.time, 0);
                            return;
                        }
                    }
                    return;
                }
                case 31: {
                    switch (event.detail) {
                        case 4: 
                        case 32: 
                        case 64: 
                        case 256: 
                        case 512: {
                            event.doit = false;
                            return;
                        }
                    }
                    event.doit = true;
                }
            }
        }

        public void paintControl(PaintEvent e) {
            int count = ColorPalette.this.fColors.size();
            if (count == 0 || ColorPalette.this.fColumnCount == 0) {
                return;
            }
            Rectangle clientArea = ColorPalette.this.getClientArea();
            int idx = ColorPalette.this.getVerticalBar().getSelection() * ColorPalette.this.fColumnCount;
            GC gc = e.gc;
            Display display = ColorPalette.this.getDisplay();
            int column = 0;
            int x = 1;
            int y = 1;
            while (idx < count) {
                ColorDef colorDef = (ColorDef)ColorPalette.this.fColors.get(idx);
                Color color = new Color((Device)display, colorDef.getRed(), colorDef.getGreen(), colorDef.getBlue());
                gc.setBackground(color);
                gc.fillRectangle(x, y, ColorPalette.this.fSize - 1, ColorPalette.this.fSize - 1);
                color.dispose();
                if (idx == ColorPalette.this.fSelectionIdx) {
                    gc.setLineStyle(1);
                    gc.setForeground(display.getSystemColor(2));
                    gc.drawRectangle(x - 1, y - 1, ColorPalette.this.fSize, ColorPalette.this.fSize);
                    gc.setForeground(ColorPalette.this.getBackground());
                    gc.drawRectangle(x, y, ColorPalette.this.fSize - 2, ColorPalette.this.fSize - 2);
                } else if (idx == count - 1 && Math.abs(colorDef.getRed() - G_BACKGROUND_DEF.getRed()) < 8 && Math.abs(colorDef.getGreen() - G_BACKGROUND_DEF.getGreen()) < 8 && Math.abs(colorDef.getBlue() - G_BACKGROUND_DEF.getBlue()) < 8) {
                    gc.setLineStyle(1);
                    gc.setForeground(display.getSystemColor(16));
                    gc.drawRectangle(x - 1, y - 1, ColorPalette.this.fSize, ColorPalette.this.fSize);
                    gc.setForeground(ColorPalette.this.getBackground());
                    gc.drawRectangle(x, y, ColorPalette.this.fSize - 2, ColorPalette.this.fSize - 2);
                }
                if (idx == ColorPalette.this.fCursorIdx && ColorPalette.this.fHasFocus) {
                    gc.setLineAttributes(SELECTION1);
                    gc.setForeground(display.getSystemColor(2));
                    gc.drawRectangle(x, y, ColorPalette.this.fSize - 2, ColorPalette.this.fSize - 2);
                    gc.setLineAttributes(SELECTION2);
                    gc.setForeground(display.getSystemColor(1));
                    gc.drawRectangle(x, y, ColorPalette.this.fSize - 2, ColorPalette.this.fSize - 2);
                }
                ++idx;
                if (++column < ColorPalette.this.fColumnCount) {
                    x += ColorPalette.this.fSize;
                    continue;
                }
                column = 0;
                x = 0;
                if ((y += ColorPalette.this.fSize) > clientArea.height) break;
            }
        }
    }
}

