/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.core.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.docmlet.tex.core.ast.ContainerNode;
import org.eclipse.statet.docmlet.tex.core.ast.NodeType;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstVisitor;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;

@NonNullByDefault
public class Group
extends ContainerNode {
    private Group(TexAstNode parent) {
        super(parent);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.GROUP;
    }

    @Override
    public final boolean hasChildren() {
        return this.children.length > 0;
    }

    @Override
    public final int getChildCount() {
        return this.children.length;
    }

    @Override
    public final TexAstNode getChild(int index) {
        return this.children[index];
    }

    @Override
    public final int getChildIndex(AstNode child) {
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i] == child) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        TexAstNode[] texAstNodeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            TexAstNode child = texAstNodeArray[n2];
            visitor.visit((AstNode)child);
            ++n2;
        }
    }

    @Override
    public void acceptInTex(TexAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public final void acceptInTexChildren(TexAstVisitor visitor) throws InvocationTargetException {
        TexAstNode[] texAstNodeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            TexAstNode child = texAstNodeArray[n2];
            child.acceptInTex(visitor);
            ++n2;
        }
    }

    @Override
    void setEndNode(int endOffset, TexAstNode endNode) {
        this.doSetEndOffset(endOffset);
    }

    @Override
    void setMissingEnd() {
        this.doSetStatusCode(4195650);
        if (this.children.length > 0) {
            this.doSetEndOffset(this.children[this.children.length - 1].getEndOffset());
        }
    }

    static final class Bracket
    extends Group {
        Bracket(TexAstNode group, int offset, int endOffset) {
            super(group);
            this.doSetStartEndOffset(offset, endOffset);
        }

        public String getText() {
            return "{";
        }
    }

    static final class Square
    extends Group {
        Square(TexAstNode group, int offset, int endOffset) {
            super(group);
            this.doSetStartEndOffset(offset, endOffset);
        }

        public String getText() {
            return "[";
        }
    }
}

