/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.eutils.autonature;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.eutils.autonature.Activator;
import org.eclipse.statet.internal.eutils.autonature.AutoConfig;
import org.eclipse.statet.internal.eutils.autonature.ConfigManager;
import org.eclipse.statet.internal.eutils.autonature.Task;
import org.eclipse.statet.internal.eutils.autonature.TaskProcessor;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class ResourceListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private final ConfigManager configManager;
    private final Map<IProject, List<AutoConfig>> projectConfigs;
    private final AtomicInteger counter = new AtomicInteger();
    private final TaskProcessor taskProcessor = new TaskProcessor();

    public ResourceListener(ConfigManager configManager) {
        this.configManager = configManager;
        this.projectConfigs = new HashMap<IProject, List<AutoConfig>>();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1 && this.configManager.hasActiveConfigs()) {
            this.counter.incrementAndGet();
            try {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)this);
                }
                catch (CoreException e) {
                    Activator.log((IStatus)new Status(4, "org.eclipse.statet.eutils.autonature", 0, "An error occurred when checking for auto configuration tasks for changed resources.", (Throwable)e));
                    if (this.counter.decrementAndGet() == 0) {
                        this.scheduleTasks();
                    }
                }
            }
            finally {
                if (this.counter.decrementAndGet() == 0) {
                    this.scheduleTasks();
                }
            }
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        switch (delta.getKind()) {
            case 1: 
            case 4: {
                IResource resource = delta.getResource();
                if (resource.getType() == 1) {
                    this.checkFile((IFile)resource);
                }
                return true;
            }
        }
        return false;
    }

    private void checkFile(IFile file) {
        try {
            IContentDescription description = file.getContentDescription();
            if (description == null) {
                return;
            }
            IContentType contentType = description.getContentType();
            if (contentType == null) {
                return;
            }
            AutoConfig config = this.configManager.getConfig(contentType, (byte)1);
            if (config != null) {
                this.addTasks(file.getProject(), config);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private synchronized void addTasks(IProject project, AutoConfig config) {
        List<AutoConfig> configs = this.projectConfigs.get(project);
        if (configs == null) {
            configs = new ArrayList<AutoConfig>(8);
            this.projectConfigs.put(project, configs);
        }
        if (!configs.contains(config)) {
            configs.add(config);
        }
    }

    private synchronized void scheduleTasks() {
        if (this.projectConfigs.isEmpty()) {
            return;
        }
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (Map.Entry<IProject, List<AutoConfig>> entry : this.projectConfigs.entrySet()) {
            IProject project = entry.getKey();
            try {
                try {
                    TaskProcessor.aggregateTasks(project, entry.getValue(), 1, tasks, null, null, SubMonitor.convert(null));
                    if (!tasks.isEmpty()) {
                        this.taskProcessor.add(project, tasks);
                    }
                }
                catch (CoreException e) {
                    Activator.log((IStatus)new Status(4, "org.eclipse.statet.eutils.autonature", 0, NLS.bind((String)"An error occurred when aggregating auto configuration tasks for project ''{0}''", (Object)project), (Throwable)e));
                    tasks.clear();
                    continue;
                }
            }
            catch (Throwable throwable) {
                tasks.clear();
                throw throwable;
            }
            tasks.clear();
        }
        this.projectConfigs.clear();
        this.taskProcessor.schedule();
    }
}

