/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.eutils.autonature;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.statet.internal.eutils.autonature.AutoConfig;
import org.eclipse.statet.internal.eutils.autonature.ConfigManager;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ContentFinder
implements IResourceVisitor {
    private final IContainer root;
    private final @Nullable Set<IPath> ignoredPaths;
    private final ConfigManager configManager;
    private final byte mode;
    private final List<AutoConfig> configs = new ArrayList<AutoConfig>();
    private final IProgressMonitor monitor;

    public ContentFinder(IContainer root, @Nullable Set<IPath> ignoredPaths, ConfigManager configManager, byte mode, IProgressMonitor monitor) {
        this.root = root;
        this.ignoredPaths = ignoredPaths;
        this.configManager = configManager;
        this.mode = mode;
        this.monitor = monitor;
    }

    public boolean visit(IResource resource) throws CoreException {
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        Set<IPath> ignoredPaths = this.ignoredPaths;
        if (resource != this.root && ignoredPaths != null) {
            for (IPath ignoredDirectory : ignoredPaths) {
                if (!ignoredDirectory.equals((Object)resource.getLocation())) continue;
                return false;
            }
        }
        switch (resource.getType()) {
            case 2: 
            case 4: {
                return true;
            }
            case 1: {
                this.checkFile((IFile)resource);
                return false;
            }
        }
        return false;
    }

    private void checkFile(IFile file) {
        try {
            IContentDescription description = file.getContentDescription();
            if (description == null) {
                return;
            }
            IContentType contentType = description.getContentType();
            if (contentType == null) {
                return;
            }
            AutoConfig config = this.configManager.getConfig(contentType, this.mode);
            if (config != null) {
                this.addTasks(config);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void addTasks(AutoConfig config) {
        if (!this.configs.contains(config)) {
            this.configs.add(config);
        }
    }

    public boolean hasTasks() {
        return !this.configs.isEmpty();
    }

    public List<AutoConfig> getConfigs() {
        return this.configs;
    }
}

