/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.ui.mode;

import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.edit.EditUtils;
import org.eclipse.statet.ecommons.waltable.ui.NatEventData;
import org.eclipse.statet.ecommons.waltable.ui.action.IDragMode;
import org.eclipse.statet.ecommons.waltable.ui.action.IKeyAction;
import org.eclipse.statet.ecommons.waltable.ui.action.IMouseAction;
import org.eclipse.statet.ecommons.waltable.ui.binding.UiBindingRegistry;
import org.eclipse.statet.ecommons.waltable.ui.mode.AbstractModeEventHandler;
import org.eclipse.statet.ecommons.waltable.ui.mode.ModeSupport;
import org.eclipse.statet.ecommons.waltable.ui.mode.MouseModeEventHandler;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;

public class ConfigurableModeEventHandler
extends AbstractModeEventHandler {
    private final NatTable natTable;

    public ConfigurableModeEventHandler(ModeSupport modeSupport, NatTable natTable) {
        super(modeSupport);
        this.natTable = natTable;
    }

    @Override
    public void keyPressed(KeyEvent event) {
        IKeyAction keyAction = this.natTable.getUiBindingRegistry().getKeyEventAction(event);
        if (keyAction != null) {
            this.natTable.forceFocus();
            keyAction.run(this.natTable, event);
        }
    }

    @Override
    public void mouseDown(MouseEvent event) {
        if (EditUtils.commitAndCloseActiveEditor()) {
            IMouseAction mouseDownAction = this.natTable.getUiBindingRegistry().getMouseDownAction(event);
            if (mouseDownAction != null) {
                event.data = NatEventData.createInstanceFromEvent(event);
                mouseDownAction.run(this.natTable, event);
            }
            IMouseAction singleClickAction = this.getUiBindingRegistry().getSingleClickAction(event);
            IMouseAction doubleClickAction = this.getUiBindingRegistry().getDoubleClickAction(event);
            IDragMode dragMode = this.natTable.getUiBindingRegistry().getDragMode(event);
            if (singleClickAction != null || doubleClickAction != null || dragMode != null) {
                this.switchMode(new MouseModeEventHandler(this.getModeSupport(), this.natTable, event, singleClickAction, doubleClickAction, dragMode));
            }
        }
    }

    @Override
    public synchronized void mouseMove(MouseEvent event) {
        if (event.x >= 0 && event.y >= 0) {
            IMouseAction mouseMoveAction = this.getUiBindingRegistry().getMouseMoveAction(event);
            if (mouseMoveAction != null) {
                event.data = NatEventData.createInstanceFromEvent(event);
                mouseMoveAction.run(this.natTable, event);
            } else {
                this.natTable.setCursor(null);
            }
        }
    }

    @Override
    public synchronized void mouseHover(MouseEvent event) {
        IMouseAction mouseHoverAction;
        if (event.x >= 0 && event.y >= 0 && (mouseHoverAction = this.getUiBindingRegistry().getMouseHoverAction(event)) != null) {
            event.data = NatEventData.createInstanceFromEvent(event);
            mouseHoverAction.run(this.natTable, event);
        }
    }

    @Override
    public synchronized void mouseEnter(MouseEvent event) {
        if (event.x >= 0 && event.y >= 0) {
            IMouseAction mouseEnterAction = this.getUiBindingRegistry().getMouseEnterAction(event);
            if (mouseEnterAction != null) {
                event.data = NatEventData.createInstanceFromEvent(event);
                mouseEnterAction.run(this.natTable, event);
            } else {
                this.natTable.setCursor(null);
            }
        }
    }

    @Override
    public synchronized void mouseExit(MouseEvent event) {
        if (event.x >= 0 && event.y >= 0) {
            IMouseAction mouseExitAction = this.getUiBindingRegistry().getMouseExitAction(event);
            if (mouseExitAction != null) {
                event.data = NatEventData.createInstanceFromEvent(event);
                mouseExitAction.run(this.natTable, event);
            } else {
                this.natTable.setCursor(null);
            }
        }
    }

    private UiBindingRegistry getUiBindingRegistry() {
        return this.natTable.getUiBindingRegistry();
    }
}

