/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.resize.core;

import org.eclipse.statet.ecommons.waltable.core.command.AbstractLayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.data.core.DataLayer;
import org.eclipse.statet.ecommons.waltable.resize.core.MultiColumnResizeCommand;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class MultiColumnResizeCommandHandler
extends AbstractLayerCommandHandler<MultiColumnResizeCommand> {
    private final DataLayer dataLayer;

    public MultiColumnResizeCommandHandler(DataLayer dataLayer) {
        this.dataLayer = dataLayer;
    }

    @Override
    public Class<MultiColumnResizeCommand> getCommandClass() {
        return MultiColumnResizeCommand.class;
    }

    @Override
    protected boolean doCommand(MultiColumnResizeCommand command) {
        LRangeList.ValueIterator columnIter = new LRangeList.ValueIterator(command.getPositions());
        while (columnIter.hasNext()) {
            long columnPosition = columnIter.nextLong();
            this.dataLayer.setColumnWidthByPosition(columnPosition, command.getColumnWidth(columnPosition));
        }
        return true;
    }
}

