/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.data;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class DataCell {
    protected long columnPosition;
    protected long rowPosition;
    protected long columnSpan;
    protected long rowSpan;

    public DataCell(long columnPosition, long rowPosition) {
        this(columnPosition, rowPosition, 1L, 1L);
    }

    public DataCell(long columnPosition, long rowPosition, long columnSpan, long rowSpan) {
        this.columnPosition = columnPosition;
        this.rowPosition = rowPosition;
        this.columnSpan = columnSpan;
        this.rowSpan = rowSpan;
    }

    public long getColumnPosition() {
        return this.columnPosition;
    }

    public long getRowPosition() {
        return this.rowPosition;
    }

    public long getColumnSpan() {
        return this.columnSpan;
    }

    public long getRowSpan() {
        return this.rowSpan;
    }

    public boolean isSpannedCell() {
        return this.columnSpan > 1L || this.rowSpan > 1L;
    }

    public int hashCode() {
        int h = (int)(this.columnPosition ^ this.columnPosition >>> 32);
        h = Integer.rotateRight(h, 15);
        h ^= (int)(this.rowPosition ^ this.rowPosition >>> 32);
        h ^= h >>> 7;
        h ^= 3 * (int)(this.columnSpan ^ this.columnSpan >>> 32);
        return h ^= 31 * (int)(this.rowSpan ^ this.rowSpan >>> 32);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DataCell) {
            DataCell other = (DataCell)obj;
            return this.columnPosition == other.columnPosition && this.rowPosition == other.rowPosition && this.columnSpan == other.columnSpan && this.rowSpan == other.rowSpan;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (\n\tcolumnPosition= " + this.columnPosition + "\n\trowPosition= " + this.rowPosition + "\n\tcolumnSpan= " + this.columnSpan + "\n\trowSpan= " + this.rowSpan + "\n)";
    }
}

