/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.command;

import org.eclipse.statet.ecommons.waltable.coordinate.ColumnPositionCoordinate;
import org.eclipse.statet.ecommons.waltable.coordinate.PositionCoordinate;
import org.eclipse.statet.ecommons.waltable.coordinate.RowPositionCoordinate;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerUtils;

public class LayerCommandUtil {
    public static PositionCoordinate convertPositionToTargetContext(PositionCoordinate positionCoordinate, Layer targetLayer) {
        Layer layer = positionCoordinate.getLayer();
        if (layer == targetLayer) {
            return positionCoordinate;
        }
        long columnPosition = positionCoordinate.getColumnPosition();
        long underlyingColumnPosition = layer.getDim(Orientation.HORIZONTAL).localToUnderlyingPosition(columnPosition, columnPosition);
        if (underlyingColumnPosition == Long.MIN_VALUE) {
            return null;
        }
        long rowPosition = positionCoordinate.getRowPosition();
        long underlyingRowPosition = layer.getDim(Orientation.VERTICAL).localToUnderlyingPosition(rowPosition, rowPosition);
        if (underlyingRowPosition == Long.MIN_VALUE) {
            return null;
        }
        Layer underlyingLayer = layer.getUnderlyingLayerByPosition(columnPosition, rowPosition);
        if (underlyingLayer == null) {
            return null;
        }
        return LayerCommandUtil.convertPositionToTargetContext(new PositionCoordinate(underlyingLayer, underlyingColumnPosition, underlyingRowPosition), targetLayer);
    }

    public static ColumnPositionCoordinate convertColumnPositionToTargetContext(ColumnPositionCoordinate columnPositionCoordinate, Layer targetLayer) {
        if (columnPositionCoordinate != null) {
            Layer layer = columnPositionCoordinate.getLayer();
            long targetPosition = LayerUtils.convertPosition(layer.getDim(Orientation.HORIZONTAL), columnPositionCoordinate.columnPosition, columnPositionCoordinate.columnPosition, targetLayer.getDim(Orientation.HORIZONTAL));
            return targetPosition != Long.MIN_VALUE ? new ColumnPositionCoordinate(targetLayer, targetPosition) : null;
        }
        return null;
    }

    public static RowPositionCoordinate convertRowPositionToTargetContext(RowPositionCoordinate rowPositionCoordinate, Layer targetLayer) {
        if (rowPositionCoordinate != null) {
            Layer layer = rowPositionCoordinate.getLayer();
            long targetPosition = LayerUtils.convertPosition(layer.getDim(Orientation.VERTICAL), rowPositionCoordinate.rowPosition, rowPositionCoordinate.rowPosition, targetLayer.getDim(Orientation.VERTICAL));
            return targetPosition != Long.MIN_VALUE ? new RowPositionCoordinate(targetLayer, targetPosition) : null;
        }
        return null;
    }
}

