/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension2;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class FixDocumentPartitioner
implements IDocumentPartitioner,
IDocumentPartitionerExtension2 {
    private final ImList<String> contentTypes;
    private @Nullable IDocument document;
    private final List<ITypedRegion> partitions;

    public FixDocumentPartitioner(ImList<String> contentTypes) {
        this.contentTypes = contentTypes;
        this.partitions = new ArrayList<ITypedRegion>();
    }

    public FixDocumentPartitioner(ImList<String> contentTypes, ImList<ITypedRegion> partitions) {
        this.contentTypes = contentTypes;
        this.partitions = partitions;
    }

    public @NonNull String @Nullable [] getManagingPositionCategories() {
        return null;
    }

    public void append(String contentType, int length) {
        if (this.partitions.isEmpty()) {
            this.partitions.add((ITypedRegion)new TypedRegion(0, length, contentType));
        } else {
            ITypedRegion previous = this.partitions.get(this.partitions.size() - 1);
            if (previous.getType() == contentType) {
                this.partitions.set(this.partitions.size() - 1, (ITypedRegion)new TypedRegion(previous.getOffset(), previous.getLength() + length, contentType));
            } else {
                this.partitions.add((ITypedRegion)new TypedRegion(previous.getOffset() + previous.getLength(), length, contentType));
            }
        }
    }

    public void connect(IDocument document) {
        this.document = document;
    }

    public void disconnect() {
        this.document = null;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public boolean documentChanged(DocumentEvent event) {
        return true;
    }

    public @NonNull String[] getLegalContentTypes() {
        return (String[])this.contentTypes.toArray((Object[])new String[this.contentTypes.size()]);
    }

    private int indexOf(int offset, boolean prefereOpen) {
        if (offset >= 0) {
            ITypedRegion partition;
            int last = this.partitions.size() - 1;
            int i = 0;
            if (!prefereOpen) {
                while (i < last) {
                    partition = this.partitions.get(i);
                    if (offset < partition.getOffset() + partition.getLength()) {
                        return i;
                    }
                    ++i;
                }
            }
            while (i <= last) {
                partition = this.partitions.get(i);
                if (offset <= partition.getOffset() + partition.getLength()) {
                    return i;
                }
                ++i;
            }
        }
        throw new IndexOutOfBoundsException("offset: " + offset);
    }

    public String getContentType(int offset) {
        return this.partitions.get(this.indexOf(offset, false)).getType();
    }

    public String getContentType(int offset, boolean preferOpen) {
        return this.partitions.get(this.indexOf(offset, preferOpen)).getType();
    }

    public @NonNull ITypedRegion[] computePartitioning(int offset, int length, boolean includeZeroLengthPartitions) {
        int startIdx = this.indexOf(offset, false);
        int endIdx = this.indexOf(offset + length, true);
        List<ITypedRegion> list = this.partitions.subList(startIdx, endIdx);
        int l = list.size();
        ITypedRegion[] array = list.toArray(new ITypedRegion[l]);
        if (!includeZeroLengthPartitions) {
            int i = 0;
            while (i < l) {
                if (array[i].getLength() == 0 && --l > i) {
                    System.arraycopy(array, i + 1, array, i, l - i);
                }
                ++i;
            }
            if (l < array.length) {
                return Arrays.copyOfRange(array, 0, l);
            }
        }
        return array;
    }

    public @NonNull ITypedRegion[] computePartitioning(int offset, int length) {
        return this.computePartitioning(offset, length, false);
    }

    public ITypedRegion getPartition(int offset) {
        return this.partitions.get(this.indexOf(offset, false));
    }

    public ITypedRegion getPartition(int offset, boolean preferOpen) {
        return this.partitions.get(this.indexOf(offset, preferOpen));
    }
}

