/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.core.runtime;

import com.ibm.icu.text.DateFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.statet.ecommons.debug.core.model.AbstractProcess;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.internal.nico.core.NicoCorePlugin;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.nico.core.runtime.History;
import org.eclipse.statet.nico.core.runtime.ITrack;
import org.eclipse.statet.nico.core.runtime.Queue;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolStatus;
import org.eclipse.statet.nico.core.runtime.ToolWorkspace;

@NonNullByDefault
public class ToolProcess
extends AbstractProcess
implements IProcess,
Tool,
ToolController.IToolStatusListener {
    public static final String PROCESS_TYPE_SUFFIX = ".nico";
    public static final int EXITCODE_DISCONNECTED = 101;
    private final String mainType;
    private final Set<String> featureSets = new HashSet<String>();
    private final String toolLabelShort;
    private final String toolLabelLong;
    private @Nullable String toolLabelTrimmedWD;
    private String toolLabelStatus;
    private final String address;
    private final long connectionTimestamp;
    private long startupTimestamp;
    private String startupWD;
    Map<String, Object> connectionInfo;
    private @Nullable ToolController controller;
    private final Queue queue;
    private final History history;
    private ToolWorkspace workspace;
    private final Object disposeLock = new Object();
    private int retain;
    private boolean isDisposed;
    private final boolean captureOutput;
    private volatile ToolStatus status = ToolStatus.STARTING;
    private final CopyOnWriteIdentityListSet<Runnable> terminationListeners = new CopyOnWriteIdentityListSet();
    private ImList<? extends ITrack> tracks = ImCollections.emptyList();

    public ToolProcess(ILaunch launch, String mainType, String labelPrefix, String name, String address, String wd, long timestamp) {
        super(launch, name);
        this.mainType = mainType;
        this.address = address;
        this.startupWD = wd;
        this.startupTimestamp = timestamp;
        this.connectionTimestamp = timestamp;
        this.toolLabelShort = labelPrefix;
        this.toolLabelLong = labelPrefix + " " + name;
        this.toolLabelStatus = ToolStatus.STARTING.getMarkedLabel();
        this.toolLabelTrimmedWD = this.trimPath(wd);
        this.captureOutput = false;
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener(new ILaunchesListener(){

            public void launchesAdded(@NonNull ILaunch[] launches) {
            }

            public void launchesChanged(@NonNull ILaunch[] launches) {
            }

            public void launchesRemoved(@NonNull ILaunch[] launches) {
                ILaunch[] iLaunchArray = launches;
                int n = launches.length;
                int n2 = 0;
                while (n2 < n) {
                    DebugPlugin plugin;
                    ILaunch launch = iLaunchArray[n2];
                    if (ToolProcess.this.getLaunch() == launch && (plugin = DebugPlugin.getDefault()) != null) {
                        plugin.getLaunchManager().removeLaunchListener((ILaunchesListener)this);
                        ToolProcess.this.dispose();
                    }
                    ++n2;
                }
            }
        });
        this.queue = new Queue(this);
        this.history = new History(this);
    }

    public void init(ToolController controller) {
        this.controller = controller;
        this.workspace = this.controller.getWorkspace();
        this.workspace.addPropertyListener(new ToolWorkspace.Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChanged(ToolWorkspace workspace, Map<String, Object> properties) {
                DebugEvent nameEvent;
                Map attributes;
                Map map = attributes = ToolProcess.this.getAttributes();
                synchronized (map) {
                    ToolProcess.this.toolLabelTrimmedWD = null;
                    nameEvent = ToolProcess.this.doSet(attributes, IProcess.ATTR_PROCESS_LABEL, ToolProcess.this.computeConsoleLabel());
                }
                if (nameEvent != null) {
                    ToolProcess.this.fireEvent(nameEvent);
                }
            }
        });
        this.toolLabelTrimmedWD = null;
        Map attributes = this.getAttributes();
        this.doSet(attributes, IProcess.ATTR_PROCESS_LABEL, this.computeConsoleLabel());
        this.doSet(attributes, IProcess.ATTR_PROCESS_TYPE, (this.mainType + PROCESS_TYPE_SUFFIX).intern());
        this.history.init();
        this.created();
    }

    public void registerFeatureSet(String featureSetID) {
        this.featureSets.add(featureSetID);
    }

    public boolean isProvidingFeatureSet(String featureSetID) {
        return this.featureSets.contains(featureSetID);
    }

    private String computeConsoleLabel() {
        String wd = this.toolLabelTrimmedWD;
        if (wd == null) {
            wd = this.toolLabelTrimmedWD = this.trimPath(FileUtil.toString((IFileStore)this.workspace.getWorkspaceDir()));
        }
        return this.toolLabelShort + " " + this.getLabel() + "  \u2219  " + wd + "   \t " + this.toolLabelStatus;
    }

    private String trimPath(@Nullable String path) {
        if (path == null) {
            return "\u2013";
        }
        if (path.length() < 30) {
            return path;
        }
        int post1 = this.prevPathSeperator(path, path.length() - 1);
        if (post1 < 25) {
            return path;
        }
        int post2 = this.prevPathSeperator(path, post1 - 1);
        if (post2 < 20) {
            return path;
        }
        int pre1 = this.nextPathSeperator(path, 0);
        int pre2 = this.nextPathSeperator(path, pre1 + 1);
        pre2 = pre2 > 12 ? 10 : ++pre2;
        if (post2 - pre2 < 10) {
            return path;
        }
        return path.substring(0, pre2) + " ... " + path.substring(post2);
    }

    private int prevPathSeperator(String path, int offset) {
        int idx2;
        int idx1 = path.lastIndexOf(47, offset);
        return idx1 > (idx2 = path.lastIndexOf(92, offset)) ? idx1 : idx2;
    }

    private int nextPathSeperator(String path, int offset) {
        int idx1 = path.indexOf(47, offset);
        int idx2 = path.indexOf(92, offset);
        return idx1 >= 0 && idx1 < idx2 ? idx1 : idx2;
    }

    public final String getMainType() {
        return this.mainType;
    }

    public String getLabel(int config) {
        if ((config & 1) != 0) {
            return this.toolLabelLong;
        }
        return this.toolLabelShort;
    }

    public @Nullable ToolController getController() {
        return this.controller;
    }

    public History getHistory() {
        return this.history;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public IStreamsProxy getStreamsProxy() {
        return this.captureOutput && this.controller != null ? this.controller.getStreams() : null;
    }

    public ToolWorkspace getWorkspace() {
        return this.workspace;
    }

    public ToolStatus getToolStatus() {
        return this.status;
    }

    void setExitValue(int value) {
        this.doSetExitValue(value);
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public void terminate() throws DebugException {
        ToolController controller = this.controller;
        if (controller != null) {
            controller.scheduleQuit();
        }
    }

    public boolean isTerminated() {
        return this.status == ToolStatus.TERMINATED;
    }

    public void addTerminationListener(Runnable listener) {
        this.terminationListeners.add((Object)((Runnable)ObjectUtils.nonNullAssert((Object)listener)));
        if (this.isTerminated() && this.terminationListeners.remove((Object)listener)) {
            listener.run();
        }
    }

    public void removeTerminationListener(Runnable listener) {
        this.terminationListeners.remove((Object)listener);
    }

    void onTerminated() {
        for (Runnable listener : this.terminationListeners.clearToList()) {
            try {
                listener.run();
            }
            catch (Exception e) {
                NicoCorePlugin.logError("An error occured when notifying a tool listener.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void controllerStatusChanged(ToolStatus oldStatus, ToolStatus newStatus, List<DebugEvent> eventCollection) {
        DebugEvent nameEvent;
        Map attributes;
        this.status = newStatus;
        if (newStatus == ToolStatus.TERMINATED) {
            this.controller = null;
            eventCollection.add(new DebugEvent((Object)this, 8));
        }
        Map map = attributes = this.getAttributes();
        synchronized (map) {
            this.toolLabelStatus = newStatus.getMarkedLabel();
            nameEvent = this.doSet(attributes, IProcess.ATTR_PROCESS_LABEL, this.computeConsoleLabel());
        }
        if (nameEvent != null) {
            eventCollection.add(nameEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dispose() {
        Object object = this.disposeLock;
        synchronized (object) {
            this.isDisposed = true;
            if (this.retain > 0) {
                return;
            }
        }
        this.doDispose();
    }

    public Map<String, Object> getConnectionInfo() {
        return this.connectionInfo;
    }

    public void prepareRestart(Map<String, Object> data) {
        if (this.status != ToolStatus.TERMINATED) {
            throw new IllegalStateException();
        }
        if (data == null) {
            throw new NullPointerException();
        }
        data.put("process", this);
        data.put("processDispose", this.poseponeDispose());
        data.put("address", this.address);
        data.put("connectionInfo", this.connectionInfo);
    }

    public void restartCompleted(Map<String, Object> data) {
        if (data == null) {
            throw new NullPointerException();
        }
        if (data.get("process") != this) {
            throw new IllegalArgumentException();
        }
        this.approveDispose(data.get("processDispose"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final @Nullable Object poseponeDispose() {
        Object object = this.disposeLock;
        synchronized (object) {
            block4: {
                if (this.retain > 0 || !this.isDisposed) break block4;
                return null;
            }
            ++this.retain;
        }
        return new AtomicBoolean(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void approveDispose(Object ticket) {
        if (ticket instanceof AtomicBoolean && ((AtomicBoolean)ticket).getAndSet(false)) {
            Object object = this.disposeLock;
            synchronized (object) {
                --this.retain;
                if (this.retain > 0 || !this.isDisposed) {
                    return;
                }
            }
            this.doDispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispose() {
        if (this.queue != null) {
            Queue queue = this.queue;
            synchronized (queue) {
                this.queue.internal_dispose();
            }
        }
        if (this.history != null) {
            this.history.dispose();
        }
        this.terminationListeners.clear();
    }

    void setTracks(List<? extends ITrack> tracks) {
        this.tracks = ImCollections.toList(tracks);
    }

    public ImList<? extends ITrack> getTracks() {
        return this.tracks;
    }

    void setStartupTimestamp(long timestamp) {
        this.startupTimestamp = timestamp;
    }

    public long getStartupTimestamp() {
        return this.startupTimestamp;
    }

    public long getConnectionTimestamp() {
        return this.connectionTimestamp;
    }

    public String createTimestampComment(long timestamp) {
        return DateFormat.getDateTimeInstance().format((Object)timestamp) + "\n";
    }

    void setStartupWD(String wd) {
        this.startupWD = wd;
    }

    public String getStartupWD() {
        return this.startupWD;
    }

    public String toString() {
        return this.toolLabelLong;
    }
}

