/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.util.Arrays;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueTupleDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.shared.common.util.ArrayUtil;

public abstract class ConstraintDescriptor
extends UniqueTupleDescriptor
implements Provider,
Dependent {
    public static final int ENABLED = 1;
    public static final int DISABLED = 2;
    public static final int ALL = 3;
    public static final int SYSCONSTRAINTS_STATE_FIELD = 6;
    TableDescriptor table;
    final String constraintName;
    private boolean deferrable;
    private boolean initiallyDeferred;
    private boolean enforced;
    private final int[] referencedColumns;
    final UUID constraintId;
    private final SchemaDescriptor schemaDesc;
    private ColumnDescriptorList colDL;

    ConstraintDescriptor(DataDictionary dataDictionary, TableDescriptor table, String constraintName, boolean deferrable, boolean initiallyDeferred, int[] referencedColumns, UUID constraintId, SchemaDescriptor schemaDesc, boolean enforced) {
        super(dataDictionary);
        this.table = table;
        this.constraintName = constraintName;
        this.deferrable = deferrable;
        this.initiallyDeferred = initiallyDeferred;
        this.referencedColumns = referencedColumns;
        this.constraintId = constraintId;
        this.schemaDesc = schemaDesc;
        this.enforced = enforced;
    }

    public UUID getTableId() {
        return this.table.getUUID();
    }

    @Override
    public UUID getUUID() {
        return this.constraintId;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public abstract int getConstraintType();

    public abstract UUID getConglomerateId();

    public String getConstraintText() {
        return null;
    }

    public boolean deferrable() {
        return this.deferrable;
    }

    public void setDeferrable(boolean b) {
        this.deferrable = b;
    }

    public boolean initiallyDeferred() {
        return this.initiallyDeferred;
    }

    public void setInitiallyDeferred(boolean b) {
        this.initiallyDeferred = b;
    }

    public int[] getReferencedColumns() {
        return ArrayUtil.copy(this.referencedColumns);
    }

    public abstract boolean hasBackingIndex();

    public SchemaDescriptor getSchemaDescriptor() {
        return this.schemaDesc;
    }

    public int[] getKeyColumns() {
        return this.getReferencedColumns();
    }

    public boolean enforced() {
        return this.enforced;
    }

    public void setEnforced(boolean b) {
        this.enforced = b;
    }

    public boolean isReferenced() {
        return false;
    }

    public int getReferenceCount() {
        return 0;
    }

    public abstract boolean needsToFire(int var1, int[] var2);

    public TableDescriptor getTableDescriptor() {
        return this.table;
    }

    public ColumnDescriptorList getColumnDescriptors() throws StandardException {
        if (this.colDL == null) {
            this.colDL = new ColumnDescriptorList();
            int[] refCols = this.getReferencedColumns();
            for (int i = 0; i < refCols.length; ++i) {
                this.colDL.add(this.table.getColumnDescriptor(refCols[i]));
            }
        }
        return this.colDL;
    }

    public boolean areColumnsComparable(ColumnDescriptorList otherColumns) throws StandardException {
        int index;
        ColumnDescriptorList myColDl = this.getColumnDescriptors();
        if (otherColumns.size() != myColDl.size()) {
            return false;
        }
        int mySize = myColDl.size();
        int otherSize = otherColumns.size();
        for (index = 0; index < mySize && index < otherSize; ++index) {
            ColumnDescriptor myColumn = myColDl.elementAt(index);
            ColumnDescriptor otherColumn = otherColumns.elementAt(index);
            if (!myColumn.getType().isExactTypeAndLengthMatch(otherColumn.getType())) break;
        }
        return index == mySize && index == otherSize;
    }

    public boolean columnIntersects(int[] columnArray) {
        return ConstraintDescriptor.doColumnsIntersect(this.getReferencedColumns(), columnArray);
    }

    static boolean doColumnsIntersect(int[] otherColumns, int[] referencedColumns) {
        if (otherColumns == null || referencedColumns == null) {
            return true;
        }
        for (int outer = 0; outer < referencedColumns.length; ++outer) {
            for (int inner = 0; inner < otherColumns.length; ++inner) {
                if (referencedColumns[outer] != otherColumns[inner]) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String tableDesc = "table: " + this.table.getQualifiedName() + "(" + this.table.getUUID() + "," + this.table.getTableType() + ")";
        return tableDesc + "\nconstraintName: " + this.constraintName + "\nconstraintId: " + this.constraintId + "\ndeferrable: " + this.deferrable + "\ninitiallyDeferred: " + this.initiallyDeferred + "\nreferencedColumns: " + Arrays.toString(this.referencedColumns) + "\nschemaDesc: " + this.schemaDesc + "\n";
    }

    @Override
    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(208);
    }

    @Override
    public String getObjectName() {
        return this.constraintName;
    }

    @Override
    public UUID getObjectID() {
        return this.constraintId;
    }

    @Override
    public String getClassType() {
        return "Constraint";
    }

    @Override
    public synchronized boolean isValid() {
        return true;
    }

    @Override
    public void prepareToInvalidate(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
        DependencyManager dm = this.getDataDictionary().getDependencyManager();
        switch (action) {
            case 20: 
            case 21: 
            case 23: 
            case 29: 
            case 30: 
            case 34: 
            case 44: 
            case 47: 
            case 48: {
                break;
            }
            default: {
                throw StandardException.newException("X0Y25.S", dm.getActionString(action), p.getObjectName(), "CONSTRAINT", this.constraintName);
            }
        }
    }

    @Override
    public void makeInvalid(int action, LanguageConnectionContext lcc) throws StandardException {
        if (action == 44 || action == 47) {
            ConglomerateDescriptor newBackingConglomCD = this.drop(lcc, true);
            this.getDataDictionary().getDependencyManager().invalidateFor(this.table, 12, lcc);
            lcc.getLastActivation().addWarning(StandardException.newWarning("01500", this.getConstraintName(), this.getTableDescriptor().getName()));
            if (newBackingConglomCD != null) {
                SanityManager.THROWASSERT("Dropped shared conglomerate due to a REVOKE and found that a new conglomerate was needed to replace it...but that shouldn't happen!");
            }
            return;
        }
        if (action != 21 && action != 20 && action != 29 && action != 30 && action != 23 && action != 48 && action != 34) {
            DependencyManager dm = this.getDataDictionary().getDependencyManager();
            SanityManager.THROWASSERT("makeInvalid(" + dm.getActionString(action) + ") not expected to get called");
        }
    }

    public ConglomerateDescriptor drop(LanguageConnectionContext lcc, boolean clearDependencies) throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        if (clearDependencies) {
            DependencyManager dm = dd.getDependencyManager();
            dm.clearDependencies(lcc, this);
        }
        dd.dropConstraintDescriptor(this, tc);
        ConglomerateDescriptor newBackingConglomCD = null;
        if (this.hasBackingIndex()) {
            ConglomerateDescriptor[] conglomDescs;
            for (ConglomerateDescriptor cd : conglomDescs = dd.getConglomerateDescriptors(this.getConglomerateId())) {
                if (!cd.isConstraint()) continue;
                newBackingConglomCD = cd.drop(lcc, this.table);
                break;
            }
        }
        this.table.removeConstraintDescriptor(this);
        return newBackingConglomCD;
    }

    @Override
    public String getDescriptorName() {
        return this.constraintName;
    }

    @Override
    public String getDescriptorType() {
        return "Constraint";
    }
}

