/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.base.ui.processing.operations;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.internal.docmlet.base.ui.processing.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

@NonNullByDefault
public class DocProcessingConfigOpenFileSetting {
    private static final String OPEN_DISABLED = "";
    private static final String OPEN_SINGLE_STEP = "step_only";
    private static final String OPEN_ALWAYS = "always";
    private static final ImList<String> OPEN_OPTIONS = ImCollections.newList((Object[])new String[]{"", "step_only", "always"});
    private final String enabledAttrName;
    private final IObservableValue<String> enabledValue;
    private ComboViewer enabledViewer;

    public DocProcessingConfigOpenFileSetting(String attrName, Realm realm) {
        this.enabledAttrName = attrName;
        this.enabledValue = new WritableValue(realm, (Object)OPEN_DISABLED, String.class);
    }

    public ComboViewer createControls(Composite parent, String labelText) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        ComboViewer viewer = new ComboViewer(parent);
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(@Nullable Object element) {
                return switch ((String)element) {
                    case DocProcessingConfigOpenFileSetting.OPEN_SINGLE_STEP -> Messages.StepTab_OpenFile_SingleStep_label;
                    case DocProcessingConfigOpenFileSetting.OPEN_ALWAYS -> Messages.StepTab_OpenFile_Always_label;
                    default -> Messages.StepTab_OpenFile_Disabled_label;
                };
            }
        });
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setInput(OPEN_OPTIONS);
        viewer.setSelection((ISelection)new StructuredSelection((Object)OPEN_DISABLED));
        this.enabledViewer = viewer;
        return viewer;
    }

    public void addBindings(DataBindingContext dbc) {
        dbc.bindValue((IObservableValue)ViewerProperties.singleSelection(String.class).observe((Viewer)this.enabledViewer), this.enabledValue);
    }

    public void load(ILaunchConfiguration configuration) throws CoreException {
        String type = OPEN_DISABLED;
        try {
            configuration.getAttribute(this.enabledAttrName, OPEN_DISABLED);
        }
        finally {
            this.enabledValue.setValue((Object)OPEN_DISABLED);
        }
    }

    public void save(ILaunchConfigurationWorkingCopy configuration) {
        String type = (String)this.enabledValue.getValue();
        if (type != null && !type.isEmpty()) {
            configuration.setAttribute(this.enabledAttrName, type);
        } else {
            configuration.removeAttribute(this.enabledAttrName);
        }
    }
}

