/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.ts.core.util;

import java.util.Map;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.ts.core.BasicToolCommandData;
import org.eclipse.statet.rj.data.RDataJConverter;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RObjectFactory;

@NonNullByDefault
public class RjToolCommandData
extends BasicToolCommandData {
    private final RList rjData;
    private final RDataJConverter rjConverter;

    public RjToolCommandData(RList rjData) {
        this.rjData = rjData;
        this.rjConverter = new RDataJConverter();
        this.rjConverter.setKeepArray1(true);
    }

    public @Nullable Object getRawData(String key) {
        return this.rjData.get(key);
    }

    protected @Nullable Object convert(@Nullable Object data, Class<?> type) {
        if (data instanceof RObject) {
            RObject rObject = (RObject)data;
            if (RObject.class.isAssignableFrom(type)) {
                return rObject.getRObjectType() == 1 ? null : INCOMPATIBLE;
            }
            data = this.rjConverter.toJava(rObject);
            if (data == null || type.isInstance(data)) {
                return data;
            }
        }
        return super.convert(data, type);
    }

    protected RList getRJReturnData(RObjectFactory rObjectFactory) {
        Map returnData = this.getReturnData();
        this.rjConverter.setRObjectFactory(rObjectFactory);
        return (RList)this.rjConverter.toRJ((Object)returnData);
    }
}

