/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.net.core.ssh.sshd;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.security.KeyPair;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.auth.UserAuthFactory;
import org.apache.sshd.client.auth.keyboard.UserAuthKeyboardInteractiveFactory;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.common.compression.BuiltinCompressions;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.eclipse.jgit.internal.transport.ssh.OpenSshConfigFile;
import org.eclipse.jgit.internal.transport.sshd.CachingKeyPairProvider;
import org.eclipse.jgit.internal.transport.sshd.GssApiWithMicAuthFactory;
import org.eclipse.jgit.internal.transport.sshd.JGitPublicKeyAuthFactory;
import org.eclipse.jgit.internal.transport.sshd.JGitServerKeyVerifier;
import org.eclipse.jgit.internal.transport.sshd.JGitSshClient;
import org.eclipse.jgit.internal.transport.sshd.JGitSshConfig;
import org.eclipse.jgit.internal.transport.sshd.JGitUserInteraction;
import org.eclipse.jgit.internal.transport.sshd.OpenSshServerKeyDatabase;
import org.eclipse.jgit.internal.transport.sshd.PasswordProviderWrapper;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.SshConfigStore;
import org.eclipse.jgit.transport.SshConstants;
import org.eclipse.jgit.transport.sshd.DefaultProxyDataFactory;
import org.eclipse.jgit.transport.sshd.IdentityPasswordProvider;
import org.eclipse.jgit.transport.sshd.KeyPasswordProvider;
import org.eclipse.jgit.transport.sshd.ProxyDataFactory;
import org.eclipse.jgit.transport.sshd.ServerKeyDatabase;
import org.eclipse.jgit.transport.sshd.agent.ConnectorFactory;
import org.eclipse.statet.internal.jcommons.net.core.sshd.SshdUtils;
import org.eclipse.statet.internal.jcommons.net.core.sshd.agent.StatetSshAgentFactory;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.io.FileUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.SystemUtils;
import org.eclipse.statet.jcommons.net.core.ssh.BasicSshClientSessionFactory;
import org.eclipse.statet.jcommons.net.core.ssh.SshClientSession;
import org.eclipse.statet.jcommons.net.core.ssh.SshTarget;
import org.eclipse.statet.jcommons.net.core.ssh.sshd.SshdClientSession;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;

@NonNullByDefault
public class SshdClientSessionFactory
extends BasicSshClientSessionFactory {
    private static final ImList<UserAuthFactory> USER_AUTH_FACTORIES = ImCollections.newList((Object[])new UserAuthFactory[]{GssApiWithMicAuthFactory.INSTANCE, JGitPublicKeyAuthFactory.FACTORY, UserAuthPasswordFactory.INSTANCE, UserAuthKeyboardInteractiveFactory.INSTANCE});
    private static final ImList<String> DEFAULT_IDENTITY_NAMES = ImCollections.newList((Object[])SshConstants.DEFAULT_IDENTITIES);
    private final Map<ConfigBase, HostConfigEntryResolver> defaultHostConfigEntryResolver = new ConcurrentHashMap<ConfigBase, HostConfigEntryResolver>();
    private final Map<ConfigBase, ServerKeyDatabase> defaultServerKeyDatabase = new ConcurrentHashMap<ConfigBase, ServerKeyDatabase>();
    private final Map<ImList<Path>, Iterable<KeyPair>> defaultKeys = new ConcurrentHashMap<ImList<Path>, Iterable<KeyPair>>();
    private final @Nullable ProxyDataFactory proxies;

    public SshdClientSessionFactory(@Nullable ProxyDataFactory proxies) {
        this.proxies = proxies;
    }

    public SshdClientSessionFactory() {
        this((ProxyDataFactory)new DefaultProxyDataFactory());
    }

    protected Path getSshDataDirectory() {
        return this.getUserHomeDirectory().resolve(".ssh");
    }

    private HostConfigEntryResolver getHostConfigEntryResolver(ConfigBase configBase) {
        return this.defaultHostConfigEntryResolver.computeIfAbsent(configBase, t -> new JGitSshConfig(this.createSshConfigStore(configBase, SystemUtils.getLocalUserName())));
    }

    protected @Nullable SshConfigStore createSshConfigStore(ConfigBase configBase, String localUserName) {
        Path configFile = configBase.getSshDataDir().resolve("config");
        return new OpenSshConfigFile(configBase.getHomeDir().toFile(), configFile.toFile(), localUserName);
    }

    protected List<Path> getDefaultIdentities(ConfigBase configBase) {
        return FileUtils.getRegularFiles((Path)configBase.getSshDataDir(), DEFAULT_IDENTITY_NAMES);
    }

    protected Iterable<KeyPair> getDefaultKeys(ConfigBase configBase) {
        List<Path> defaultIdentities = this.getDefaultIdentities(configBase);
        return this.defaultKeys.computeIfAbsent((ImList<Path>)ImCollections.toList(defaultIdentities), t -> new CachingKeyPairProvider(defaultIdentities, null));
    }

    protected ServerKeyDatabase getServerKeyDatabase(ConfigBase configBase) {
        return this.defaultServerKeyDatabase.computeIfAbsent(configBase, this::createServerKeyDatabase);
    }

    protected ServerKeyDatabase createServerKeyDatabase(ConfigBase configBase) {
        return new OpenSshServerKeyDatabase(true, this.getDefaultKnownHostsFiles(configBase));
    }

    protected List<Path> getDefaultKnownHostsFiles(ConfigBase configBase) {
        return ImCollections.newList((Object[])new Path[]{configBase.getSshDataDir().resolve("known_hosts"), configBase.getSshDataDir().resolve("known_hosts2")});
    }

    protected @Nullable String getDefaultPreferredAuthenticationMethodsString() {
        return null;
    }

    protected KeyPasswordProvider createKeyPasswordProvider(@Nullable CredentialsProvider provider) {
        return new IdentityPasswordProvider(provider);
    }

    private FilePasswordProvider createFilePasswordProvider(Supplier<KeyPasswordProvider> providerFactory) {
        return new PasswordProviderWrapper(providerFactory);
    }

    protected @Nullable ConnectorFactory getConnectorFactory() {
        return ConnectorFactory.getDefault();
    }

    protected SshClientSession createSession(SshTarget target, @Nullable Duration timeout, ProgressMonitor m) throws StatusException {
        m.setWorkRemaining(4);
        JGitSshClient client = this.createClient(target, this.getCreditalsProvider());
        SshdClientSession session = new SshdClientSession(target, timeout, (SshClient)client);
        m.addWorked(1);
        session.connect(m);
        return session;
    }

    protected @Nullable CredentialsProvider getCreditalsProvider() {
        return CredentialsProvider.getDefault();
    }

    protected JGitSshClient createClient(SshTarget target, @Nullable CredentialsProvider credentialsProvider) throws StatusException {
        ConfigBase configBase = new ConfigBase(this.getUserHomeDirectory(), this.getSshDataDirectory());
        HostConfigEntryResolver configFile = this.getHostConfigEntryResolver(configBase);
        KeyIdentityProvider defaultKeysProvider = SshdUtils.toKeyIdentityProvider(this.getDefaultKeys(configBase));
        Supplier<KeyPasswordProvider> keyPasswordProvider = () -> this.createKeyPasswordProvider(credentialsProvider);
        JGitSshClient client = (JGitSshClient)((ClientBuilder)((ClientBuilder)ClientBuilder.builder().factory(JGitSshClient::new)).filePasswordProvider(this.createFilePasswordProvider(keyPasswordProvider)).hostConfigEntryResolver(configFile).serverKeyVerifier((ServerKeyVerifier)new JGitServerKeyVerifier(this.getServerKeyDatabase(configBase))).compressionFactories((List)ImCollections.toList((Collection)BuiltinCompressions.VALUES))).build();
        client.setUserInteraction((UserInteraction)new JGitUserInteraction(credentialsProvider));
        client.setUserAuthFactories(USER_AUTH_FACTORIES);
        client.setKeyIdentityProvider(defaultKeysProvider);
        client.setKeyPasswordProviderFactory(keyPasswordProvider);
        ConnectorFactory connectorFactory = this.getConnectorFactory();
        if (connectorFactory != null) {
            client.setAgentFactory((SshAgentFactory)new StatetSshAgentFactory(connectorFactory, configBase.getHomeDir()));
        }
        client.setProxyDatabase(this.proxies);
        client.setCredentialsProvider(credentialsProvider);
        String defaultAuths = this.getDefaultPreferredAuthenticationMethodsString();
        if (defaultAuths != null) {
            client.setAttribute(JGitSshClient.PREFERRED_AUTHENTICATIONS, (Object)defaultAuths);
        }
        try {
            client.setAttribute(JGitSshClient.HOME_DIRECTORY, (Object)configBase.getHomeDir());
        }
        catch (SecurityException | InvalidPathException runtimeException) {
            // empty catch block
        }
        return client;
    }

    protected static class ConfigBase {
        private final Path homeDir;
        private final Path sshDataDir;

        public ConfigBase(Path homeDir, Path sshDir) {
            this.homeDir = homeDir.toAbsolutePath().normalize();
            this.sshDataDir = sshDir.toAbsolutePath().normalize();
        }

        public final Path getHomeDir() {
            return this.homeDir;
        }

        public final Path getSshDataDir() {
            return this.sshDataDir;
        }

        public int hashCode() {
            return 31 * this.homeDir.hashCode() + this.homeDir.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            block2: {
                block3: {
                    if (obj == this) break block2;
                    if (!(obj instanceof ConfigBase)) break block3;
                    ConfigBase other = (ConfigBase)obj;
                    if (this.homeDir.equals(other.homeDir) && this.sshDataDir.equals(other.sshDataDir)) break block2;
                }
                return false;
            }
            return true;
        }
    }
}

