/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.util;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.participants.CopyProcessor;
import org.eclipse.ltk.core.refactoring.participants.CopyRefactoring;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.MoveRefactoring;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.ltk.ui.refactoring.Messages;
import org.eclipse.statet.ltk.model.core.ElementSet;
import org.eclipse.statet.ltk.model.core.element.SourceElement;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.refactoring.core.CommonRefactoringFactory;
import org.eclipse.statet.ltk.refactoring.core.RefactoringAdapter;
import org.eclipse.statet.ltk.refactoring.core.RefactoringDestination;
import org.eclipse.statet.ltk.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorAssociated;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.statushandlers.StatusManager;

public class ViewerSelectionTransferDropAdapter
extends ViewerDropAdapter
implements TransferDropTargetListener {
    private final IAdaptable part;
    private final CommonRefactoringFactory refactoring;
    private RefactoringAdapter adapter;
    private ElementSet elements;
    private MoveProcessor moveProcessor;
    private int canMoveElements;
    private CopyProcessor copyProcessor;
    private int canCopyElements;
    private ISelection selection;

    public ViewerSelectionTransferDropAdapter(StructuredViewer viewer, CommonRefactoringFactory refactoring) {
        this(viewer, null, refactoring);
    }

    public ViewerSelectionTransferDropAdapter(StructuredViewer viewer, IAdaptable part, CommonRefactoringFactory refactoring) {
        super((Viewer)viewer);
        this.part = part;
        this.refactoring = refactoring;
        this.setScrollEnabled(true);
        this.setExpandEnabled(true);
        this.setSelectionFeedbackEnabled(false);
        this.setFeedbackEnabled(false);
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getTransfer();
    }

    public boolean isEnabled(DropTargetEvent event) {
        Object target;
        Object object = target = event.item != null ? event.item.getData() : null;
        if (target == null) {
            return false;
        }
        return target instanceof SourceStructElement;
    }

    public void dragEnter(DropTargetEvent event) {
        this.clear();
        super.dragEnter(event);
    }

    public void dragLeave(DropTargetEvent event) {
        this.clear();
        super.dragLeave(event);
    }

    private void clear() {
        this.setSelectionFeedbackEnabled(false);
        this.elements = null;
        this.selection = null;
        this.moveProcessor = null;
        this.canMoveElements = 0;
        this.copyProcessor = null;
        this.canCopyElements = 0;
        this.adapter = null;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        int result = this.internalDetermineOperation(target, operation, 3);
        if (result == 0) {
            this.setSelectionFeedbackEnabled(false);
            return false;
        }
        this.setSelectionFeedbackEnabled(true);
        this.overrideOperation(result);
        return true;
    }

    private int internalDetermineOperation(Object target, int operation, int operations) {
        block14: {
            if (!(target instanceof SourceElement) || !this.initializeSelection()) {
                return 0;
            }
            if (this.elements.getResources().size() > 0) {
                return 0;
            }
            this.elements.removeElementsWithAncestorsOnList();
            RefactoringDestination destination = new RefactoringDestination(target, switch (this.getCurrentLocation()) {
                case 1 -> RefactoringDestination.Position.ABOVE;
                case 2 -> RefactoringDestination.Position.BELOW;
                default -> RefactoringDestination.Position.INTO;
            });
            this.adapter = this.refactoring.createAdapter((Object)destination);
            if (this.adapter == null || !this.adapter.canInsert(this.elements, destination)) {
                return 0;
            }
            try {
                switch (operation) {
                    case 16: {
                        return this.handleValidateDefault(destination, operations);
                    }
                    case 1: {
                        return this.handleValidateCopy(destination);
                    }
                    case 2: {
                        return this.handleValidateMove(destination);
                    }
                }
            }
            catch (CoreException e) {
                if (e.getStatus().getSeverity() != 4) break block14;
                StatusManager.getManager().handle((IStatus)new Status(4, this.adapter.getPluginIdentifier(), -1, "An error occurred when validation the drop location.", (Throwable)e));
            }
        }
        return 0;
    }

    protected boolean initializeSelection() {
        if (this.elements != null) {
            return this.elements.isOK();
        }
        ISelection s = LocalSelectionTransfer.getTransfer().getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return false;
        }
        this.selection = s;
        this.elements = new ElementSet(((IStructuredSelection)s).toArray());
        return this.elements.isOK();
    }

    protected ISelection getSelection() {
        return this.selection;
    }

    public boolean performDrop(Object data) {
        switch (this.getCurrentOperation()) {
            case 2: {
                return this.handleDropMove();
            }
            case 1: {
                return this.handleDropCopy();
            }
        }
        return false;
    }

    private int handleValidateDefault(RefactoringDestination destination, int operations) throws CoreException {
        int result;
        if ((operations & 2) != 0 && (result = this.handleValidateMove(destination)) != 0) {
            return result;
        }
        return this.handleValidateCopy(destination);
    }

    private int handleValidateMove(RefactoringDestination destination) throws CoreException {
        MoveProcessor processor;
        if (this.moveProcessor == null && (processor = this.refactoring.createMoveProcessor((Object)this.elements, destination, this.adapter)) != null && processor.isApplicable()) {
            this.moveProcessor = processor;
        }
        return this.canMoveElements() ? 2 : 0;
    }

    private boolean canMoveElements() {
        if (this.canMoveElements == 0) {
            int n = this.canMoveElements = this.moveProcessor != null ? 2 : 1;
        }
        return this.canMoveElements == 2;
    }

    protected boolean handleDropMove() {
        try {
            this.execute((Refactoring)new MoveRefactoring(this.moveProcessor));
            return true;
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, this.adapter.getPluginIdentifier(), -1, Messages.MoveElements_error_message, e.getCause()), 3);
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private int handleValidateCopy(RefactoringDestination destination) throws CoreException {
        CopyProcessor processor;
        if (this.copyProcessor == null && (processor = this.refactoring.createCopyProcessor((Object)this.elements, destination, this.adapter)) != null && processor.isApplicable()) {
            this.copyProcessor = processor;
        }
        return this.canCopyElements() ? 1 : 0;
    }

    private boolean canCopyElements() {
        if (this.canCopyElements == 0) {
            int n = this.canCopyElements = this.copyProcessor != null ? 2 : 1;
        }
        return this.canCopyElements == 2;
    }

    protected boolean handleDropCopy() {
        try {
            this.execute((Refactoring)new CopyRefactoring(this.copyProcessor));
            return true;
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, this.adapter.getPluginIdentifier(), -1, Messages.CopyElements_error_message, e.getCause()), 3);
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    protected void execute(Refactoring refactoring) throws InterruptedException, InvocationTargetException {
        Position position;
        SourceUnit su;
        SourceEditorAssociated associated;
        IWorkbenchWindow window = UIAccess.getActiveWorkbenchWindow((boolean)true);
        IProgressService context = (IProgressService)window.getService(IProgressService.class);
        RefactoringExecutionHelper helper = new RefactoringExecutionHelper(refactoring, RefactoringCore.getConditionCheckingFailedSeverity(), this.getShell(), context);
        SourceEditor editor = null;
        if (this.part != null && (editor = (SourceEditor)this.part.getAdapter(SourceEditor.class)) == null && (associated = (SourceEditorAssociated)this.part.getAdapter(SourceEditorAssociated.class)) != null) {
            editor = associated.getSourceEditor();
        }
        if (editor != null && (su = editor.getSourceUnit()) != null) {
            helper.enableInsertPosition(su);
        }
        helper.perform(false, false);
        if (editor != null && (position = helper.getInsertPosition()) != null) {
            editor.selectAndReveal(position.getOffset(), 0);
        }
    }

    private Shell getShell() {
        return this.getViewer().getControl().getShell();
    }

    protected int getCurrentLocation() {
        if (this.getFeedbackEnabled()) {
            return super.getCurrentLocation();
        }
        return 3;
    }
}

