/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.compare;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
class CompareUtilities {
    CompareUtilities() {
    }

    public static String readString(IStreamContentAccessor input) {
        try {
            String encoding = null;
            if (input instanceof IEncodedStreamContentAccessor) {
                encoding = ((IEncodedStreamContentAccessor)input).getCharset();
            }
            if (encoding == null) {
                encoding = ResourcesPlugin.getEncoding();
            }
            return CompareUtilities.readString(input, encoding);
        }
        catch (CoreException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", -1, "An error occurred when loading compare input.", (Throwable)e));
            return "";
        }
    }

    public static String readString(IStreamContentAccessor sca, String encoding) throws CoreException {
        try {
            Charset charset = Charset.forName(encoding);
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream in = sca.getContents();){
                return new String(in.readAllBytes(), charset);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | UnsupportedCharsetException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", -1, e.getMessage(), (Throwable)e));
        }
    }
}

