/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks;

import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.statet.docmlet.wikitext.core.source.SourceElementAttributes;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.LineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockNode;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockType;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlocks;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class IndentedCodeBlock
extends SourceBlockType<CodeBlockNode> {
    @Override
    public boolean canStart(LineSequence lineSequence, @Nullable SourceBlockNode<?> currentNode) {
        Line line = lineSequence.getCurrentLine();
        return line != null && !line.isBlank() && line.getIndent() >= 4 && currentNode == null;
    }

    @Override
    public void createNodes(SourceBlocks.SourceBlockBuilder builder) {
        Line line;
        CodeBlockNode node = new CodeBlockNode(this, builder);
        LineSequence lineSequence = builder.getLineSequence();
        lineSequence.advance();
        while ((line = lineSequence.getCurrentLine()) != null) {
            if (line.isBlank()) {
                int end = this.lookAheadSafeLine(lineSequence.lookAhead());
                if (end == Integer.MIN_VALUE) break;
                IndentedCodeBlock.advanceLinesUpto(lineSequence, end);
                continue;
            }
            if (line.getIndent() < 4) break;
            lineSequence.advance();
        }
    }

    private int lookAheadSafeLine(LineSequence lineSequence) {
        Line line;
        while ((line = lineSequence.getCurrentLine()) != null) {
            if (line.isBlank()) {
                lineSequence.advance();
                continue;
            }
            if (line.getIndent() < 4) break;
            return line.getLineNumber();
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public void initializeContext(ProcessingContext context, CodeBlockNode node) {
    }

    @Override
    public void emit(ProcessingContext context, CodeBlockNode node, CommonmarkLocator locator, DocumentBuilder builder) {
        ImList<Line> lines = node.getLines();
        SourceElementAttributes attributes = new SourceElementAttributes(256);
        locator.setBlockBegin(node);
        builder.beginBlock(DocumentBuilder.BlockType.CODE, (Attributes)attributes);
        for (Line line : lines) {
            if (line.getIndent() >= 4) {
                Line codeSegment = line.segmentByIndent(4);
                locator.setLine(codeSegment);
                builder.characters(codeSegment.getCodeContent());
                builder.characters("\n");
                continue;
            }
            builder.characters("\n");
        }
        locator.setBlockEnd(node);
        builder.endBlock();
    }

    static final class CodeBlockNode
    extends SourceBlockNode<IndentedCodeBlock> {
        private CodeBlockNode(IndentedCodeBlock type, SourceBlocks.SourceBlockBuilder builder) {
            super(type, builder);
        }
    }
}

