/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.redocs.tex.r.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.statet.docmlet.tex.core.TexCore;
import org.eclipse.statet.docmlet.tex.core.TexCoreAccess;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.redocs.tex.r.core.util.TexRweaveCoreAccessWrapper;

@NonNullByDefault
public class TexRweaveCore {
    public static final String BUNDLE_ID = "org.eclipse.statet.redocs.tex.r";
    public static final String LTX_R_CONTENT_ID = "org.eclipse.statet.redocs.contentTypes.LtxRweave";
    public static final IContentType LTX_R_CONTENT_TYPE;
    private static final TexCoreAccess TEX_WORKBENCH_ACCESS;
    private static final Map<IProject, TexRweaveCoreAccessWrapper> TEX_PROJECT_ACCESS_MAP;

    static {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        LTX_R_CONTENT_TYPE = (IContentType)ObjectUtils.nonNullAssert((Object)contentTypeManager.getContentType(LTX_R_CONTENT_ID));
        TEX_WORKBENCH_ACCESS = new TexRweaveCoreAccessWrapper(TexCore.getWorkbenchAccess());
        TEX_PROJECT_ACCESS_MAP = new HashMap<IProject, TexRweaveCoreAccessWrapper>();
    }

    public static TexCoreAccess getWorkbenchAccess() {
        return TEX_WORKBENCH_ACCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TexCoreAccess getResourceTexCoreAccess(IResource resource) {
        IProject project = resource.getProject();
        if (project != null) {
            TexRweaveCoreAccessWrapper wrapper;
            TexCoreAccess parent = TexCore.getContextAccess((IAdaptable)project);
            Map<IProject, TexRweaveCoreAccessWrapper> map = TEX_PROJECT_ACCESS_MAP;
            synchronized (map) {
                wrapper = TEX_PROJECT_ACCESS_MAP.get(project);
                if (wrapper == null) {
                    wrapper = new TexRweaveCoreAccessWrapper(parent);
                    TEX_PROJECT_ACCESS_MAP.put(project, wrapper);
                    return wrapper;
                }
            }
            wrapper.setParent(parent);
            return wrapper;
        }
        return TexRweaveCore.getWorkbenchAccess();
    }

    public static TexCoreAccess getContextAccess(@Nullable IAdaptable adaptable) {
        if (adaptable != null && adaptable instanceof IResource) {
            return TexRweaveCore.getResourceTexCoreAccess((IResource)adaptable);
        }
        return TexRweaveCore.getWorkbenchAccess();
    }
}

