/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.tex.r.ui.sourceediting;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.statet.internal.redocs.tex.r.RedocsTexRPlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.TemplateCompletionComputer;
import org.eclipse.statet.ltk.ui.sourceediting.assist.TemplateProposal;
import org.eclipse.statet.redocs.r.ui.RedocsRUIResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.templates.ContextTypeRegistry;

@NonNullByDefault
public class RChunkTemplateCompletionComputer
extends TemplateCompletionComputer {
    public RChunkTemplateCompletionComputer() {
        super(RedocsTexRPlugin.getInstance().getCodegenTemplateStore(), (ContextTypeRegistry)RedocsTexRPlugin.getInstance().getCodegenTemplateContextTypeRegistry());
    }

    public void computeCompletionProposals(AssistInvocationContext context, int mode, AssistProposalCollector proposals, IProgressMonitor monitor) {
        if (mode == 1) {
            mode = 2;
        }
        super.computeCompletionProposals(context, mode, proposals, monitor);
    }

    protected boolean include(Template template, TemplateProposal.TemplateProposalParameters<?> parameters) {
        parameters.matchRule = 0x1000000;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected @Nullable String extractPrefix(AssistInvocationContext context) {
        IDocument document = context.getSourceViewer().getDocument();
        int offset = context.getOffset();
        try {
            int lineOffset = document.getLineOffset(document.getLineOfOffset(offset));
            switch (offset - lineOffset) {
                case 2: {
                    if (document.getChar(lineOffset) != '<' || document.getChar(lineOffset + 1) != '<') break;
                    return "<<";
                }
                case 1: {
                    if (document.getChar(lineOffset) != '<') break;
                    return "<";
                }
                case 0: {
                    return "";
                }
            }
            return null;
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    protected TemplateContextType getContextType(AssistInvocationContext context, TextRegion region) {
        return this.getTypeRegistry().getContextType("Ltx+Rweave_Weave:DocDefault");
    }

    protected Image getImage(Template template) {
        return RedocsRUIResources.INSTANCE.getImage("org.eclipse.statet.redocs.r/images/obj/rchunk");
    }
}

