/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.debug.core.breakpoints;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.statet.ecommons.resources.core.util.MarkerUpdate;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.internal.r.debug.core.RDebugCorePlugin;
import org.eclipse.statet.internal.r.debug.core.breakpoints.GenericLineBreakpoint;
import org.eclipse.statet.internal.r.debug.core.breakpoints.LineBreakpointImpl;
import org.eclipse.statet.internal.r.debug.core.breakpoints.MethodBreakpointImpl;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.r.console.core.RDbg;
import org.eclipse.statet.r.core.model.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.model.RWorkspaceSourceUnit;
import org.eclipse.statet.r.core.model.rlang.RLangSrcStrElement;
import org.eclipse.statet.r.core.source.ast.FDef;
import org.eclipse.statet.r.core.source.ast.GenericVisitor;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAstVisitor;
import org.eclipse.statet.r.core.source.ast.RAsts;
import org.eclipse.statet.r.core.source.doc.RDocumentConstants;
import org.eclipse.statet.r.core.source.util.RHeuristicTokenScanner;
import org.eclipse.statet.r.debug.core.breakpoints.RBreakpoint;
import org.eclipse.statet.r.debug.core.breakpoints.RLineBreakpoint;
import org.eclipse.statet.r.nico.IRSrcref;
import org.eclipse.statet.r.nico.RSrcref;

public class RLineBreakpointValidator {
    private static final int LINE_TOLERANCE = 5;
    private static final String TOPLEVEL_ELEMENT_ID = "200:";
    private final RWorkspaceSourceUnit sourceUnit;
    private final AbstractDocument document;
    private RSourceUnitModelInfo modelInfo;
    private String type;
    private int originalLine;
    private int line;
    private int startOffset;
    private int endOffset;
    private RLangSrcStrElement methodElement;
    private RLangSrcStrElement baseElement;
    private RAstNode astNode;
    private RAstNode baseExpressionRootNode;

    public static ModelPosition getModelPosition(RLineBreakpoint breakpoint) {
        LineBreakpointImpl internal;
        GenericLineBreakpoint.CachedData cachedData;
        if (breakpoint instanceof LineBreakpointImpl && (cachedData = (internal = (LineBreakpointImpl)breakpoint).getCachedData()) != null) {
            return new ModelPosition(cachedData);
        }
        return null;
    }

    public RLineBreakpointValidator(RWorkspaceSourceUnit su, String type, int offset, IProgressMonitor monitor) {
        this.sourceUnit = su;
        if (!this.initType(type) || this.sourceUnit.getResource().getType() != 1) {
            this.document = null;
            this.setInvalid();
            return;
        }
        this.document = this.sourceUnit.getDocument(monitor);
        this.endOffset = -1;
        this.startOffset = -1;
        this.line = -1;
        this.originalLine = -1;
        this.check(offset, monitor);
    }

    public RLineBreakpointValidator(RWorkspaceSourceUnit su, RLineBreakpoint breakpoint, IProgressMonitor monitor) throws CoreException {
        this.sourceUnit = su;
        if (!this.initType(breakpoint.getBreakpointType()) || this.sourceUnit.getResource().getType() != 1) {
            this.document = null;
            this.setInvalid();
            return;
        }
        this.document = this.sourceUnit.getDocument(monitor);
        this.endOffset = -1;
        this.startOffset = -1;
        this.line = -1;
        this.originalLine = -1;
        int offset = breakpoint.getCharStart();
        this.check(offset, monitor);
        if (this.type != null && breakpoint instanceof GenericLineBreakpoint && su.isSynchronized()) {
            ((GenericLineBreakpoint)breakpoint).setCachedData(new GenericLineBreakpoint.CachedData(this.modelInfo.getStamp().getContentStamp(), this.computeElementId(), this.computeRExpressionIndex()));
        }
    }

    private boolean initType(String type) {
        if (type == null) {
            return true;
        }
        if (type.equals("org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint")) {
            this.type = "org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint";
            return true;
        }
        if (type.equals("org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint")) {
            this.type = "org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint";
            return true;
        }
        return false;
    }

    private void check(int offset, IProgressMonitor monitor) {
        block21: {
            try {
                this.line = this.originalLine = this.document.getLineOfOffset(offset);
                this.methodElement = this.searchMethodElement(offset, monitor);
                if (this.type == null) {
                    this.type = this.methodElement != null && this.document.getLineOfOffset(this.methodElement.getSourceRange().getStartOffset()) == this.line ? "org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint" : "org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint";
                }
                if (this.type == "org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint") {
                    IRegion lineInformation = this.document.getLineInformation(this.line);
                    RHeuristicTokenScanner scanner = RHeuristicTokenScanner.create((DocContentSections)this.sourceUnit.getDocumentContentInfo());
                    scanner.configure((IDocument)this.document, RDocumentConstants.R_CODE_CONTENT_CONSTRAINT);
                    IRegion lastLineInformation = this.document.getLineInformation(Math.min(this.line + 5, this.document.getNumberOfLines() - 1));
                    this.startOffset = scanner.findNonMSpaceForward(lineInformation.getOffset(), lastLineInformation.getOffset() + lastLineInformation.getLength());
                    if (this.startOffset < 0) {
                        this.setInvalid();
                        return;
                    }
                    this.astNode = this.searchSuspendAstNode(this.startOffset, monitor);
                    if (this.astNode == null) {
                        this.setInvalid();
                        return;
                    }
                    this.startOffset = this.astNode.getStartOffset();
                    if (this.startOffset < 0) {
                        this.setInvalid();
                        return;
                    }
                    this.line = this.document.getLineOfOffset(this.startOffset);
                    if (this.line != this.originalLine) {
                        lineInformation = this.document.getLineInformation(this.line);
                    }
                    this.endOffset = scanner.findNonMSpaceBackward(lineInformation.getOffset() + lineInformation.getLength(), this.startOffset);
                    if (this.endOffset < 0) {
                        this.setInvalid();
                        return;
                    }
                    if (this.methodElement != null && this.methodElement.getSourceRange().getStartOffset() != this.startOffset) {
                        this.baseElement = this.searchBaseElement(this.methodElement);
                        if (this.baseElement == null) {
                            this.setInvalid();
                            return;
                        }
                        this.baseExpressionRootNode = ((FDef)this.baseElement.getAdapter(FDef.class)).getContChild();
                        if (!this.isBaseExpressionRootNodeValid()) {
                            this.setInvalid();
                            return;
                        }
                    } else {
                        this.baseExpressionRootNode = this.astNode.getRRoot();
                    }
                    break block21;
                }
                if (this.type == "org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint") {
                    if (this.methodElement != null) {
                        this.startOffset = this.methodElement.getSourceRange().getStartOffset();
                        if (this.startOffset < 0) {
                            this.setInvalid();
                            return;
                        }
                        this.line = this.document.getLineOfOffset(this.startOffset);
                        IRegion lineInformation = this.document.getLineInformation(this.line);
                        RHeuristicTokenScanner scanner = RHeuristicTokenScanner.create((DocContentSections)this.sourceUnit.getDocumentContentInfo());
                        scanner.configure((IDocument)this.document, RDocumentConstants.R_CODE_CONTENT_CONSTRAINT);
                        this.endOffset = scanner.findNonMSpaceBackward(Math.min(lineInformation.getOffset() + lineInformation.getLength(), this.startOffset + this.methodElement.getSourceRange().getLength()), this.startOffset);
                        if (this.endOffset < 0) {
                            this.setInvalid();
                            return;
                        }
                        this.baseElement = this.searchBaseElement(this.methodElement);
                        if (this.baseElement == null) {
                            this.setInvalid();
                            return;
                        }
                        if (this.baseElement != this.methodElement) {
                            this.astNode = ((FDef)this.methodElement.getAdapter(FDef.class)).getContChild();
                            if (this.astNode == null) {
                                this.setInvalid();
                                return;
                            }
                            this.baseExpressionRootNode = ((FDef)this.baseElement.getAdapter(FDef.class)).getContChild();
                            if (!this.isBaseExpressionRootNodeValid()) {
                                this.setInvalid();
                                return;
                            }
                        }
                        break block21;
                    }
                    this.setInvalid();
                    return;
                }
                throw new IllegalStateException(this.type);
            }
            catch (BadLocationException e) {
                this.setInvalid();
            }
        }
    }

    private boolean isBaseExpressionRootNodeValid() {
        return this.baseExpressionRootNode != null && this.baseExpressionRootNode.getNodeType() == NodeType.BLOCK && RAsts.isParentChild((RAstNode)this.baseExpressionRootNode, (RAstNode)this.astNode);
    }

    private RSourceUnitModelInfo getModelInfo(IProgressMonitor monitor) {
        if (this.modelInfo == null) {
            this.modelInfo = (RSourceUnitModelInfo)this.sourceUnit.getModelInfo("R", 2, monitor);
        }
        return this.modelInfo;
    }

    private void setInvalid() {
        this.type = null;
    }

    private RLangSrcStrElement searchMethodElement(int offset, IProgressMonitor monitor) throws BadLocationException {
        RSourceUnitModelInfo modelInfo = this.getModelInfo(monitor);
        if (modelInfo == null) {
            return null;
        }
        IRegion lineInformation = this.document.getLineInformationOfOffset(offset);
        RHeuristicTokenScanner scanner = RHeuristicTokenScanner.create((DocContentSections)this.sourceUnit.getDocumentContentInfo());
        scanner.configure((IDocument)this.document, RDocumentConstants.R_CODE_CONTENT_CONSTRAINT);
        int charStart = scanner.findNonMSpaceForward(lineInformation.getOffset(), lineInformation.getOffset() + lineInformation.getLength());
        if (charStart < 0) {
            charStart = offset;
        }
        SourceStructElement element = LtkModelUtils.getCoveringSourceElement((SourceStructElement)modelInfo.getSourceElement(), (int)charStart, (int)charStart);
        while (element != null) {
            if (element instanceof RLangSrcStrElement && (element.getElementType() & 0xF00) == 1280) {
                return (RLangSrcStrElement)element;
            }
            element = element.getSourceParent();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private RAstNode searchSuspendAstNode(final int offset, IProgressMonitor monitor) {
        block7: {
            block8: {
                modelInfo = this.getModelInfo(monitor);
                if (modelInfo == null) {
                    return null;
                }
                astNode = AstSelection.search((AstNode)modelInfo.getAst().getRoot(), (int)offset, (int)offset, (int)2).getCovering();
                if (!(astNode instanceof RAstNode)) break block7;
                rNode = (RAstNode)astNode;
                if (rNode.getStartOffset() >= offset) ** GOTO lbl17
                ref = new AtomicReference<V>();
                try {
                    rNode.acceptInR((RAstVisitor)new GenericVisitor(){

                        public void visitNode(RAstNode node) throws InvocationTargetException {
                            if (ref.get() != null) {
                                return;
                            }
                            if (node.getStartOffset() >= offset) {
                                ref.set(node);
                                return;
                            }
                            if (node.getEndOffset() >= offset) {
                                node.acceptInRChildren((RAstVisitor)this);
                            }
                        }
                    });
                }
                catch (InvocationTargetException var7_8) {
                    // empty catch block
                }
                if (ref.get() == null) break block8;
                return (RAstNode)ref.get();
lbl-1000:
                // 1 sources

                {
                    rNode = rParent;
lbl17:
                    // 2 sources

                    ** while ((rParent = rNode.getRParent()) != null && rParent.getStartOffset() >= offset)
                }
            }
            return rNode;
        }
        return null;
    }

    private RLangSrcStrElement searchBaseElement(RLangSrcStrElement element) {
        while (element != null) {
            SourceStructElement parent = element.getSourceParent();
            if (!(parent instanceof RLangSrcStrElement)) {
                return null;
            }
            if ((parent.getElementType() & 0xF00) == 512) {
                if ((element.getElementType() & 0xF00) == 1280 && element.getAdapter(FDef.class) != null) {
                    return element;
                }
                return null;
            }
            element = (RLangSrcStrElement)parent;
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public int getOriginalLineNumber() {
        return this.originalLine + 1;
    }

    public int getLineNumber() {
        return this.line >= 0 ? this.line + 1 : -1;
    }

    public int getCharStart() {
        return this.startOffset;
    }

    public int getCharEnd() {
        return this.endOffset >= 0 ? this.endOffset + 1 : -1;
    }

    public SourceStructElement getMethodElement() {
        return this.methodElement;
    }

    public SourceStructElement getBaseElement() {
        return this.baseElement;
    }

    public RAstNode getAstNode() {
        return this.astNode;
    }

    public int computeElementType() throws CoreException {
        if (this.type == null) {
            throw this.invalid();
        }
        if (this.baseElement != null) {
            if ((this.baseElement.getElementType() & 0xF00) == 1280) {
                if (this.baseElement.getElementType() == 1408) {
                    return 2;
                }
                return 1;
            }
        } else {
            return 9;
        }
        return -1;
    }

    public String computeElementId() throws CoreException {
        if (this.type == null) {
            throw this.invalid();
        }
        if (this.baseElement != null) {
            return RDbg.getElementId((RLangSrcStrElement)this.baseElement);
        }
        return TOPLEVEL_ELEMENT_ID;
    }

    public String computeElementLabel() throws CoreException {
        if (this.type == null) {
            throw this.invalid();
        }
        if (this.baseElement != null) {
            return this.getLabel((SourceStructElement)this.baseElement);
        }
        try {
            return this.document.get(this.getCharStart(), this.getCharEnd() - this.getCharStart());
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    public String computeSubLabel() throws CoreException {
        if (this.type == null) {
            throw this.invalid();
        }
        if (this.baseElement != null) {
            RAstNode astNode = this.astNode;
            while (astNode != null && astNode.getNodeType() != NodeType.F_DEF) {
                astNode = astNode.getRParent();
            }
            if (astNode != null && (this.methodElement == null || astNode != this.methodElement.getAdapter(FDef.class) && astNode.getStartOffset() > this.methodElement.getSourceRange().getStartOffset())) {
                return "<unnamed>";
            }
            if (this.methodElement != null && this.methodElement != this.baseElement) {
                return this.getLabel((SourceStructElement)this.methodElement);
            }
            return null;
        }
        return null;
    }

    private String getLabel(SourceStructElement element) {
        return element.getElementName().toString();
    }

    public @Nullable IRSrcref computeElementSrcref() throws CoreException {
        if (this.type == null) {
            throw this.invalid();
        }
        try {
            if (this.baseElement != null) {
                FDef astNode = (FDef)this.baseElement.getAdapter(FDef.class);
                if (astNode != null) {
                    return new RSrcref((IDocument)this.document, (TextRegion)astNode.getContChild());
                }
            } else if (this.baseExpressionRootNode != null) {
                return new RSrcref((IDocument)this.document, (TextRegion)this.baseExpressionRootNode);
            }
            return null;
        }
        catch (BadLocationException e) {
            throw this.failedComputing(e);
        }
    }

    public int[] computeRExpressionIndex() throws CoreException {
        if (this.type == null) {
            throw this.invalid();
        }
        if (this.astNode != null && this.baseExpressionRootNode != null) {
            return RAsts.computeRExpressionIndex((RAstNode)this.astNode, (RAstNode)this.baseExpressionRootNode);
        }
        return null;
    }

    public RSrcref @Nullable [] computeRExpressionSrcrefs() throws CoreException {
        if (this.type == null) {
            throw this.invalid();
        }
        if (this.astNode != null && this.baseExpressionRootNode != null) {
            List nodes = RAsts.computeRExpressionNodes((RAstNode)this.astNode, (RAstNode)this.baseExpressionRootNode);
            try {
                RSrcref[] srcrefs = new RSrcref[nodes.size()];
                int i = 0;
                while (i < srcrefs.length) {
                    RAstNode node = (RAstNode)nodes.get(i);
                    if (i == srcrefs.length - 1 || node.getNodeType() == NodeType.BLOCK) {
                        srcrefs[i] = new RSrcref((IDocument)this.document, (TextRegion)node);
                    }
                    ++i;
                }
                return srcrefs;
            }
            catch (BadLocationException e) {
                throw this.failedComputing(e);
            }
        }
        return null;
    }

    public RBreakpoint createBreakpoint(IProgressMonitor monitor) {
        if (this.type == null) {
            return null;
        }
        if (this.type == "org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint") {
            try {
                String elementId = this.computeElementId();
                LineBreakpointImpl internal = new LineBreakpointImpl(this.sourceUnit.getResource(), this.getLineNumber(), this.getCharStart(), this.getCharEnd(), this.computeElementType(), elementId, this.computeElementLabel(), this.computeSubLabel(), false);
                internal.setCachedData(new GenericLineBreakpoint.CachedData(this.modelInfo.getStamp().getContentStamp(), elementId, this.computeRExpressionIndex()));
                return internal;
            }
            catch (Exception e) {
                RDebugCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", "An error occurred when creating R line breakpoint from validation data\n" + this.toString(), (Throwable)e));
                return null;
            }
        }
        if (this.type == "org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint") {
            try {
                String elementId = this.computeElementId();
                MethodBreakpointImpl internal = new MethodBreakpointImpl(this.sourceUnit.getResource(), this.getLineNumber(), this.getCharStart(), this.getCharEnd(), this.computeElementType(), elementId, this.computeElementLabel(), this.computeSubLabel(), false);
                internal.setCachedData(new GenericLineBreakpoint.CachedData(this.modelInfo.getStamp().getContentStamp(), elementId, this.computeRExpressionIndex()));
                return internal;
            }
            catch (Exception e) {
                RDebugCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", "An error occurred when creating R method breakpoint from validation data\n" + this.toString(), (Throwable)e));
                return null;
            }
        }
        throw new IllegalStateException("type= " + this.type);
    }

    public void updateBreakpoint(RBreakpoint breakpoint) throws CoreException {
        if (this.type != breakpoint.getBreakpointType()) {
            throw new IllegalArgumentException(this.type);
        }
        if (!(breakpoint instanceof RLineBreakpoint)) {
            throw new IllegalArgumentException(breakpoint.getClass().getName());
        }
        MarkerUpdate markerUpdate = new MarkerUpdate(breakpoint.getMarker(), 3);
        String elementId = this.computeElementId();
        GenericLineBreakpoint.updatePosition(markerUpdate, this.getLineNumber(), this.getCharStart(), this.getCharEnd());
        GenericLineBreakpoint.updateElementInfo(markerUpdate, this.computeElementType(), elementId, this.computeElementLabel(), this.computeSubLabel());
        markerUpdate.apply();
        if (breakpoint instanceof GenericLineBreakpoint) {
            ((GenericLineBreakpoint)breakpoint).setCachedData(new GenericLineBreakpoint.CachedData(this.modelInfo.getStamp().getContentStamp(), elementId, this.computeRExpressionIndex()));
        }
    }

    private CoreException invalid() {
        return new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", 0, "Validation result was negative.", null));
    }

    private CoreException failedComputing(Throwable e) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", 0, "An error occurred when computing breakpoint data.", e));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("\n").append("validator result:");
        sb.append("\n\t").append("type= ").append(this.type != null ? this.type : "<no valid position found>");
        sb.append("\n\t").append("lineNumber= ").append(this.getLineNumber());
        sb.append("\n\t").append("charStart= ").append(this.getCharStart());
        sb.append("\n\t").append("charEnd= ").append(this.getCharEnd());
        return sb.toString();
    }

    public static class ModelPosition {
        private final GenericLineBreakpoint.CachedData fData;

        private ModelPosition(GenericLineBreakpoint.CachedData data) {
            this.fData = data;
        }

        public String getElementId() {
            return this.fData.getElementId();
        }

        public int[] getRExpressionIndex() {
            return this.fData.getRExpressionIndex();
        }
    }
}

