/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.statet.ecommons.debug.core.model.IndexedValue;
import org.eclipse.statet.ecommons.debug.core.model.VariablePartition;
import org.eclipse.statet.ecommons.debug.core.model.VariablePartitionFactory;
import org.eclipse.statet.ecommons.models.core.util.ElementPartitionFactory;
import org.eclipse.statet.internal.r.debug.core.model.RDebugElement;
import org.eclipse.statet.internal.r.debug.core.model.RDebugTargetImpl;
import org.eclipse.statet.internal.r.debug.core.model.RIndexElementValue;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.debug.core.RDebugTarget;
import org.eclipse.statet.r.debug.core.RValue;
import org.eclipse.statet.r.debug.core.RVariable;

@NonNullByDefault
public abstract class RElementValue<TRElement extends CombinedRElement>
extends RDebugElement
implements RValue {
    protected static final @NonNull RVariable[] NO_VARIABLES = new RVariable[0];
    protected static final VariablePartitionFactory<RIndexElementValue> PARTITION_FACTORY = new VariablePartitionFactory<RIndexElementValue>(){

        protected RVariable createPartition(RIndexElementValue value, ElementPartitionFactory.PartitionHandle partition) {
            return new RVariablePartition(value, partition);
        }
    };
    protected final TRElement element;
    protected final int stamp;

    public RElementValue(RDebugTargetImpl debugTarget, TRElement element, int stamp) {
        super(debugTarget);
        this.element = element;
        this.stamp = stamp;
    }

    public final TRElement getElement() {
        return this.element;
    }

    @Override
    public String getValueString() throws DebugException {
        switch (this.element.getRObjectType()) {
            case 1: {
                return "NULL";
            }
        }
        return "";
    }

    public String getReferenceTypeName() throws DebugException {
        return this.element.getRClassName();
    }

    @Override
    public String getDetailString() {
        switch (this.element.getRObjectType()) {
            case 1: {
                return "NULL";
            }
        }
        return "";
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public boolean hasVariables() throws DebugException {
        return false;
    }

    public @NonNull IVariable[] getVariables() throws DebugException {
        return NO_VARIABLES;
    }

    protected static class RVariablePartition
    extends VariablePartition<RIndexElementValue>
    implements RVariable,
    RValue {
        public RVariablePartition(RIndexElementValue value, ElementPartitionFactory.PartitionHandle partition) {
            super((IndexedValue)value, partition);
        }

        @Override
        public RDebugTarget getDebugTarget() {
            return (RDebugTarget)super.getDebugTarget();
        }

        @Override
        public @Nullable RVariable getParent() {
            return null;
        }

        protected int getNameIndexBase() {
            return 1;
        }

        @Override
        public RValue getValue() {
            return this;
        }

        @Override
        public RVariable getAssignedVariable() {
            return this;
        }

        @Override
        public String getDetailString() {
            return "";
        }
    }
}

